/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_176;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.KUtil;
import snownee.lychee.Lychee;
import snownee.lychee.mixin.LootContextParamSetsAccess;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class LycheeRecipeType<T extends ILycheeRecipe<LycheeContext>>
implements class_3956<T> {
    public final class_2960 id;
    public class_2960 categoryId;
    public final Class<? extends T> clazz;
    public final class_176 contextParamSet;
    protected List<class_8786<T>> recipes;
    public boolean requiresClient;
    public boolean canPreventConsumeInputs;
    private boolean empty = true;
    public static final class_2561 DEFAULT_PREVENT_TIP = class_2561.method_43471((String)"tip.lychee.preventDefault.default").method_27692(class_124.field_1054);

    public LycheeRecipeType(String name, Class<T> clazz, @Nullable class_176 contextParamSet) {
        this.id = this.categoryId = Lychee.id(name);
        this.clazz = clazz;
        this.contextParamSet = contextParamSet == null ? (class_176)LootContextParamSetsAccess.registry().get((Object)this.id) : contextParamSet;
        Objects.requireNonNull(this.contextParamSet);
    }

    public String toString() {
        return "LycheeRecipeType[" + String.valueOf(this.id) + "]";
    }

    public Optional<class_8786<T>> tryMatch(class_8786<T> recipeHolder, class_1937 level, LycheeContext context) {
        ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.comp_1933();
        return recipe.method_8115(context, level) && recipe.test(recipe, context, 1) > 0 ? Optional.of(recipeHolder) : Optional.empty();
    }

    public List<class_8786<T>> recipes() {
        return this.recipes;
    }

    public List<class_8786<T>> inViewerRecipes() {
        return KUtil.getRecipes((class_3956)this).stream().filter(it -> !((ILycheeRecipe)it.comp_1933()).hideInRecipeViewer()).toList();
    }

    public void updateEmptyState() {
        this.empty = this.recipes.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @MustBeInvokedByOverriders
    public void refreshCache() {
        this.recipes = KUtil.getRecipes((class_3956)this).stream().filter(it -> !((ILycheeRecipe)it.comp_1933()).ghost()).sorted(this.comparator()).toList();
    }

    public Comparator<class_8786<T>> comparator() {
        return Comparator.comparing(class_8786::comp_1933, Comparator.comparing(class_1860::method_8118));
    }

    public Optional<class_8786<T>> findFirst(LycheeContext context, class_1937 level) {
        return this.recipes.stream().flatMap(it -> this.tryMatch((class_8786<T>)it, level, context).stream()).findFirst();
    }

    public class_2561 getPreventDefaultDescription(T recipe) {
        return DEFAULT_PREVENT_TIP;
    }
}

