/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.render;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.mixin.EntityAccess;

public class CachedRenderingEntity<T extends class_1297> {
    protected T entity;
    protected float scale = 15.0f;
    protected Vector3f translation = new Vector3f(0.0f, 0.0f, 20.0f);
    private Function<class_1937, T> factory;

    protected CachedRenderingEntity(T entity) {
        this.setEntity(entity);
    }

    protected CachedRenderingEntity(Function<class_1937, T> factory) {
        this.factory = factory;
    }

    public static <T extends class_1297> CachedRenderingEntity<T> of(T entity) {
        return new CachedRenderingEntity<T>(entity);
    }

    public static <T extends class_1297> CachedRenderingEntity<T> ofFactory(Function<class_1937, T> factory) {
        return new CachedRenderingEntity<T>(factory);
    }

    private void ensureEntity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull((class_1297)this.factory.apply((class_1937)class_310.method_1551().field_1687));
            this.factory = null;
        }
    }

    public T getEntity() {
        this.ensureEntity();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            ((class_1297)this.entity).field_6012 = player.field_6012;
        }
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
        this.factory = null;
        ((EntityAccess)entity).callSetLevel(null);
    }

    public void earlySetLevel() {
        this.ensureEntity();
        ((EntityAccess)this.entity).callSetLevel((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687));
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void render(class_4587 matrixStack, Quaternionf rotation) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        this.ensureEntity();
        ((EntityAccess)this.entity).callSetLevel((class_1937)mc.field_1687);
        ((class_1297)this.entity).field_6012 = (int)(mc.field_1687.method_8510() % 240000L);
        class_243 position = mc.field_1773.method_19418().method_19326();
        this.entity.method_23327(position.method_10216(), position.method_10214(), position.method_10215());
        matrixStack.method_22903();
        matrixStack.method_46416(this.translation.x, this.translation.y, this.translation.z);
        matrixStack.method_22905(this.scale, this.scale, this.scale);
        matrixStack.method_22907(rotation);
        class_898 renderDispatcher = mc.method_1561();
        rotation.conjugate();
        renderDispatcher.method_24196(rotation);
        renderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        renderDispatcher.method_3954(this.entity, 0.0, 0.0, 0.0, mc.method_60646().method_60637(true), 1.0f, matrixStack, (class_4597)bufferSource, 0xF000F0);
        bufferSource.method_22993();
        renderDispatcher.method_3948(true);
        matrixStack.method_22909();
        ((EntityAccess)this.entity).callSetLevel(null);
        ILightingSettings.DEFAULT_3D.applyLighting();
    }
}

