/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.ui;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.ui.SpriteElementRenderer;
import snownee.lychee.ui.TextElementRenderer;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.ui.UIElement;
import snownee.lychee.util.ui.UIElementCommonProperties;
import snownee.lychee.util.ui.UIElementType;

public interface ElementRenderer {
    public static final Map<UIElementType<?>, Function<? extends UIElement, ? extends RenderElement>> FACTORIES = Maps.newIdentityHashMap();

    public static void init() {
        ElementRenderer.register(UIElementType.SPRITE, SpriteElementRenderer::create);
        ElementRenderer.register(UIElementType.ITEM, it -> GuiGameElement.of(it.itemStack()));
        ElementRenderer.register(UIElementType.BLOCK, it -> GuiGameElement.of(BlockPredicateExtensions.anyBlockState(it.block())));
        ElementRenderer.register(UIElementType.TEXT, TextElementRenderer::create);
    }

    public static RenderElement of(UIElement element) {
        return ElementRenderer.of(element, null);
    }

    public static RenderElement of(UIElement element, @Nullable class_8786<?> recipeHolder) {
        Function<? extends UIElement, ? extends RenderElement> function = FACTORIES.get(element.type());
        RenderElement renderElement = function == null ? RenderElement.empty() : function.apply(element);
        UIElementCommonProperties properties = element.commonProperties();
        if (properties.tooltip().isPresent()) {
            InteractiveRenderElement interactiveElement = InteractiveRenderElement.create(renderElement);
            List<class_2561> tooltip = properties.tooltip().get();
            renderElement = interactiveElement.onTooltip(() -> tooltip);
        }
        String id = properties.onInput().orElse(null);
        if (recipeHolder != null && id != null) {
            InteractiveRenderElement interactiveElement = InteractiveRenderElement.create(renderElement);
            renderElement = interactiveElement.onInput((action, element0) -> ClientProxy.postWidgetInputEvent(recipeHolder.comp_1933(), id, action, element0));
        }
        ((RenderElement)((RenderElement)renderElement.at(properties.pos())).withSize(properties.size())).withAlpha(properties.opacity());
        return renderElement;
    }

    public static <T extends UIElement> void register(UIElementType<T> type, Function<T, ? extends RenderElement> renderer) {
        FACTORIES.put(type, renderer);
    }
}

