/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.effect;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.effect.impl.DummyEffect;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public abstract class CrateEffect {
    protected final String id;
    protected final long tickInterval;
    protected final int maxSteps;
    protected long tickCount;

    public CrateEffect(@NotNull String id, long tickInterval, int maxSteps) {
        this.id = id;
        this.tickCount = 0L;
        this.tickInterval = Math.max(1L, tickInterval);
        this.maxSteps = Math.max(0, maxSteps);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public abstract String getName();

    public boolean isDummy() {
        return this == DummyEffect.INSTANCE;
    }

    public void complete() {
        this.tickCount = -10L;
    }

    public void addTickCount() {
        ++this.tickCount;
    }

    public void playStep(@NotNull Location location, @NotNull UniParticle particle, @NotNull Player player) {
        if (this.tickCount < 0L || this.tickCount % this.tickInterval != 0L) {
            return;
        }
        this.onStepPlay(LocationUtil.setCenter2D((Location)location.clone()), particle, (int)this.tickCount, player);
        if (this.tickCount >= (long)this.maxSteps) {
            this.complete();
        }
    }

    public abstract void onStepPlay(@NotNull Location var1, @NotNull UniParticle var2, int var3, @NotNull Player var4);

    @NotNull
    public static Location getPointOnCircle(@NotNull Location location, boolean doCopy, double x, double z, double y) {
        return (doCopy ? location.clone() : location).add(Math.cos(x) * z, y, Math.sin(x) * z);
    }

    public final long getTickInterval() {
        return this.tickInterval;
    }

    public final int getMaxSteps() {
        return this.maxSteps;
    }
}

