/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.impl.ItemReward;
import su.nightexpress.excellentcrates.dialog.CrateDialogs;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardContentMenu
extends LinkedMenu<CratesPlugin, ItemReward>
implements LangContainer {
    private static final IconLocale LOCALE_PLACEHOLDERS = LangEntry.iconBuilder((String)"Editor.Button.Reward.ItemPlaceholders").name("Item Placeholders").appendCurrent("State", "%state%").br().appendInfo(new String[]{"Allows to replace item placeholders:"}).appendInfo(new String[]{TagWrappers.SOFT_YELLOW.wrap("\u2192") + " Crate placeholders " + TagWrappers.DARK_GRAY.wrap("(see docs)")}).appendInfo(new String[]{TagWrappers.SOFT_YELLOW.wrap("\u2192") + " Reward placeholders " + TagWrappers.DARK_GRAY.wrap("(see docs)")}).appendInfo(new String[]{TagWrappers.SOFT_YELLOW.wrap("\u2192") + " %player_name% placeholder."}).br().appendClick("Click to toggle").build();

    public RewardContentMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_REWARD_CONTENT.text());
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(0, 9).toArray()));
        this.addItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(36, 45).toArray()));
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openRewardOptions(viewer.getPlayer(), (Reward)this.getLink(viewer)))));
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        ItemStack clicked = result.getItemStack();
        if (clicked == null || clicked.getType().isAir()) {
            return;
        }
        Player player = viewer.getPlayer();
        ItemStack copy = new ItemStack(clicked);
        ItemReward reward = (ItemReward)this.getLink(viewer);
        Crate crate = reward.getCrate();
        Runnable flush = () -> this.flush(player);
        if (result.isInventory()) {
            if (!ItemHelper.isCustom(copy)) {
                reward.addItem(ItemHelper.vanilla(copy));
                crate.markDirty();
                this.runNextTick(flush);
            } else {
                CrateDialogs.REWARD_ITEM.ifPresent(dialog -> dialog.show(player, reward, copy, flush));
            }
        } else {
            int slot = result.getSlot();
            if (slot < 9 || slot > 27) {
                return;
            }
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{copy});
            if (event.isRightClick()) {
                return;
            }
            int index = slot - 9;
            reward.getItems().remove(index);
            crate.markDirty();
            clicked.setAmount(0);
            this.runNextTick(flush);
        }
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        ItemReward reward = (ItemReward)this.getLink(player);
        viewer.addItem(NightItem.fromType((Material)Material.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE).localized(LOCALE_PLACEHOLDERS).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(reward.isAllowItemPlaceholders()))).toMenuItem().setSlots(new int[]{4}).setHandler((viewer1, event) -> {
            reward.setAllowItemPlaceholders(!reward.isAllowItemPlaceholders());
            reward.getCrate().markDirty();
            this.runNextTick(() -> this.flush(player));
        }).build());
    }

    public void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
        List<AdaptedItem> items = ((ItemReward)this.getLink(viewer)).getItems();
        for (int index = 0; index < 27 && index < items.size(); ++index) {
            int slot = index + 9;
            inventory.setItem(slot, items.get(index).getItemStack());
        }
    }
}

