/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.command.basic;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.command.CommandArguments;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.config.Perms;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.crate.impl.OpenOptions;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Players;

public class BaseCommands {
    public static void load(@NotNull CratesPlugin plugin, @NotNull HubNodeBuilder root) {
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"reload").description(CoreLang.COMMAND_RELOAD_DESC)).permission((Permission)Perms.COMMAND_RELOAD)).executes((context, arguments) -> {
            plugin.doReload(context.getSender());
            return true;
        })});
        root.branch(new ExecutableNodeBuilder[]{((HubNodeBuilder)((HubNodeBuilder)Commands.hub((String)"key").description(Lang.COMMAND_KEY_DESC)).permission((Permission)Perms.COMMAND_KEY)).branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"drop").description(Lang.COMMAND_DROP_KEY_DESC)).permission((Permission)Perms.COMMAND_DROP_KEY)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.forKey(plugin), Arguments.decimal((String)"x").localized(Lang.COMMAND_ARGUMENT_NAME_X).suggestions((reader, context) -> BaseCommands.getCoords(context, Location::getBlockX)), Arguments.decimal((String)"y").localized(Lang.COMMAND_ARGUMENT_NAME_Y).suggestions((reader, context) -> BaseCommands.getCoords(context, Location::getBlockY)), Arguments.decimal((String)"z").localized(Lang.COMMAND_ARGUMENT_NAME_Z).suggestions((reader, context) -> BaseCommands.getCoords(context, Location::getBlockZ)), Arguments.world((String)"world")}).executes((context, arguments) -> BaseCommands.dropKey(plugin, context, arguments))}).branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"inspect").description(Lang.COMMAND_KEY_INSPECT_DESC)).permission((Permission)Perms.COMMAND_KEY_INSPECT)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission((Permission)Perms.COMMAND_KEY_INSPECT_OTHERS)).optional()}).executes((context, arguments) -> BaseCommands.inspectKeys(plugin, context, arguments))}).branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"giveall").description(Lang.COMMAND_KEY_GIVE_ALL_DESC)).permission((Permission)Perms.COMMAND_KEY_GIVE)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.forKey(plugin), Arguments.integer((String)"amount", (int)1).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1", "5", "10"})).optional()}).withFlags(new String[]{"s", "sf"}).executes((context, arguments) -> BaseCommands.giveKeyAll(plugin, context, arguments))}).branch(new ExecutableNode[]{Commands.literal((String)"give", builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)BaseCommands.buildKeyManage(plugin, builder).description(Lang.COMMAND_KEY_GIVE_DESC)).permission((Permission)Perms.COMMAND_KEY_GIVE)).executes((context, arguments) -> BaseCommands.giveKey(plugin, context, arguments)))}).branch(new ExecutableNode[]{Commands.literal((String)"set", builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)BaseCommands.buildKeyManage(plugin, builder).description(Lang.COMMAND_KEY_SET_DESC)).permission((Permission)Perms.COMMAND_KEY_SET)).executes((context, arguments) -> BaseCommands.setKey(plugin, context, arguments)))}).branch(new ExecutableNode[]{Commands.literal((String)"take", builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)BaseCommands.buildKeyManage(plugin, builder).description(Lang.COMMAND_KEY_TAKE_DESC)).permission((Permission)Perms.COMMAND_KEY_TAKE)).executes((context, arguments) -> BaseCommands.takeKey(plugin, context, arguments)))})});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"drop").description(Lang.COMMAND_DROP_DESC)).permission((Permission)Perms.COMMAND_DROP)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.forCrate(plugin), Arguments.decimal((String)"x").localized(Lang.COMMAND_ARGUMENT_NAME_X).suggestions((reader, context) -> BaseCommands.getCoords(context, Location::getBlockX)), Arguments.decimal((String)"y").localized(Lang.COMMAND_ARGUMENT_NAME_Y).suggestions((reader, context) -> BaseCommands.getCoords(context, Location::getBlockY)), Arguments.decimal((String)"z").localized(Lang.COMMAND_ARGUMENT_NAME_Z).suggestions((reader, context) -> BaseCommands.getCoords(context, Location::getBlockZ)), Arguments.world((String)"world")}).executes((context, arguments) -> BaseCommands.dropCrate(plugin, context, arguments))});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"editor").description(Lang.COMMAND_EDITOR_DESC)).permission((Permission)Perms.COMMAND_EDITOR)).playerOnly()).executes((context, arguments) -> BaseCommands.openEditor(plugin, context))});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"give").description(Lang.COMMAND_GIVE_DESC)).permission((Permission)Perms.COMMAND_GIVE)).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player"), CommandArguments.forCrate(plugin), Arguments.integer((String)"amount", (int)1).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1", "5", "10"})).optional()}).withFlags(new String[]{"s", "sf"}).executes((context, arguments) -> BaseCommands.giveCrate(plugin, context, arguments))});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"open").description(Lang.COMMAND_OPEN_DESC)).permission((Permission)Perms.COMMAND_OPEN)).playerOnly()).withArguments(new ArgumentNodeBuilder[]{CommandArguments.forCrate(plugin)}).executes((context, arguments) -> BaseCommands.openCrate(plugin, context, arguments))});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"openfor").description(Lang.COMMAND_OPEN_FOR_DESC)).permission((Permission)Perms.COMMAND_OPEN_FOR)).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player"), CommandArguments.forCrate(plugin)}).withFlags(new String[]{"s", "f"}).executes((context, arguments) -> BaseCommands.openCrateFor(plugin, context, arguments))});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"preview").description(Lang.COMMAND_PREVIEW_DESC)).permission((Permission)Perms.COMMAND_PREVIEW)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.forCrate(plugin), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission((Permission)Perms.COMMAND_PREVIEW_OTHERS)).optional()}).executes((context, arguments) -> BaseCommands.previewCrate(plugin, context, arguments))});
        root.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"resetcooldown").description(Lang.COMMAND_RESET_COOLDOWN_DESC)).permission((Permission)Perms.COMMAND_RESETCOOLDOWN)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), CommandArguments.forCrate(plugin)}).executes((context, arguments) -> BaseCommands.resetCrateCooldown(plugin, context, arguments))});
    }

    @NotNull
    private static List<String> getCoords(@NotNull CommandContext context, @NotNull Function<Location, Integer> function) {
        Player player = context.getPlayer();
        if (player == null) {
            return Collections.emptyList();
        }
        Location location = player.getLocation();
        return Lists.newList((Object[])new String[]{String.valueOf(function.apply(location))});
    }

    @NotNull
    private static LiteralNodeBuilder buildKeyManage(@NotNull CratesPlugin plugin, @NotNull LiteralNodeBuilder builder) {
        return builder.withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), CommandArguments.forKey(plugin), Arguments.integer((String)"amount", (int)1).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1", "5", "10"})).optional()}).withFlags(new String[]{"s", "sf"});
    }

    private static boolean dropCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Crate crate = (Crate)arguments.get("crate", Crate.class);
        double x = arguments.getDouble("x");
        double y = arguments.getDouble("y");
        double z = arguments.getDouble("z");
        World world = arguments.getWorld("world");
        Location location = new Location(world, x, y, z);
        if (!plugin.getCrateManager().dropCrateItem(crate, location)) {
            return false;
        }
        Lang.COMMAND_DROP_DONE.message().send(context.getSender(), replacer -> replacer.replace(crate.replacePlaceholders()).replace(Placeholders.forLocation((Location)location)));
        return true;
    }

    private static boolean openEditor(@NotNull CratesPlugin plugin, @NotNull CommandContext context) {
        plugin.getEditorManager().openEditor(context.getPlayerOrThrow());
        return true;
    }

    private static boolean giveCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = arguments.getPlayer("player");
        Crate crate = (Crate)arguments.get("crate", Crate.class);
        int amount = arguments.getInt("amount", 1);
        plugin.getCrateManager().giveCrateItem(player, crate, amount);
        if (!context.hasFlag("s")) {
            Lang.COMMAND_GIVE_NOTIFY.message().send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)amount).replace(crate.replacePlaceholders()));
        }
        if (!context.hasFlag("sf") && context.getSender() != player) {
            Lang.COMMAND_GIVE_DONE.message().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)player)).replace("%amount%", (Object)amount).replace(crate.replacePlaceholders()));
        }
        return true;
    }

    private static boolean openCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Crate crate = (Crate)arguments.get("crate", Crate.class);
        Player player = context.getPlayerOrThrow();
        plugin.getCrateManager().preOpenCrate(player, new CrateSource(crate));
        return true;
    }

    private static boolean openCrateFor(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = arguments.getPlayer("player");
        Crate crate = (Crate)arguments.get("crate", Crate.class);
        if (!context.hasFlag("s")) {
            Lang.COMMAND_OPEN_FOR_NOTIFY.message().send(context.getSender(), replacer -> replacer.replace(crate.replacePlaceholders()));
        }
        if (context.getSender() != player) {
            Lang.COMMAND_OPEN_FOR_DONE.message().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)player)).replace(crate.replacePlaceholders()));
        }
        boolean force = context.hasFlag("f");
        CrateSource source = new CrateSource(crate);
        if (!force) {
            plugin.getCrateManager().openCrate(player, source, OpenOptions.empty(), null);
        } else {
            plugin.getCrateManager().openCrate(player, source, OpenOptions.ignoreRestrictions(), null);
        }
        return true;
    }

    private static boolean previewCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Crate crate = (Crate)arguments.get("crate", Crate.class);
        Player player = plugin.getServer().getPlayer(arguments.getString("player", context.getSender().getName()));
        if (player == null) {
            context.errorBadPlayer();
            return false;
        }
        plugin.getCrateManager().previewCrate(player, new CrateSource(crate));
        if (context.getSender() != player) {
            Lang.COMMAND_PREVIEW_DONE_OTHERS.message().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)player)).replace(crate.replacePlaceholders()));
        }
        return true;
    }

    private static boolean resetCrateCooldown(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        plugin.getUserManager().manageUser(arguments.getString("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            Crate crate = (Crate)arguments.get("crate", Crate.class);
            user.getCrateData(crate).setOpenCooldown(0L);
            plugin.getUserManager().save((AbstractUser)user);
            Lang.COMMAND_RESET_COOLDOWN_DONE.message().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace(crate.replacePlaceholders()));
        });
        return true;
    }

    private static boolean dropKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)arguments.get("key", CrateKey.class);
        double x = arguments.getDouble("x");
        double y = arguments.getDouble("y");
        double z = arguments.getDouble("z");
        World world = arguments.getWorld("world");
        Location location = new Location(world, x, y, z);
        if (!plugin.getKeyManager().dropKeyItem(key, location)) {
            return false;
        }
        Lang.COMMAND_DROP_KEY_DONE.message().send(context.getSender(), replacer -> replacer.replace(key.replacePlaceholders()).replace(Placeholders.forLocation((Location)location)));
        return true;
    }

    private static boolean giveKeyAll(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)arguments.get("key", CrateKey.class);
        int amount = arguments.getInt("amount", 1);
        if (amount == 0) {
            return false;
        }
        boolean silent = context.hasFlag("s");
        Players.getOnline().forEach(player -> {
            if (!player.hasPermission((Permission)Perms.INCLUDE_KEY_GIVEALL)) {
                return;
            }
            plugin.getKeyManager().giveKey((Player)player, key, amount);
            if (!silent) {
                Lang.COMMAND_KEY_GIVE_NOTIFY.message().send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        if (!context.hasFlag("sf")) {
            Lang.COMMAND_KEY_GIVE_ALL_DONE.message().send(context.getSender(), replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
        }
        return true;
    }

    private static boolean inspectKeys(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        plugin.getUserManager().manageUser(arguments.getString("player", context.getSender().getName()), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            Lang.COMMAND_KEY_INSPECT_LIST.message().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%entry%", list -> plugin.getKeyManager().getKeys().forEach(key -> {
                if (!key.isVirtual()) {
                    return;
                }
                list.add((String)key.replacePlaceholders().apply(Lang.COMMAND_KEY_INSPECT_ENTRY.text().replace("%amount%", NumberUtil.format((double)user.countKeys(key.getId())))));
            })));
        });
        return true;
    }

    private static boolean giveKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)arguments.get("key", CrateKey.class);
        int amount = arguments.getInt("amount", 1);
        if (amount <= 0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getString("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            plugin.getKeyManager().giveKey((CrateUser)((Object)user), key, amount);
            plugin.getUserManager().save((AbstractUser)user);
            Player target = user.getPlayer();
            if (target != null && !context.hasFlag("s")) {
                Lang.COMMAND_KEY_GIVE_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
            if (!context.hasFlag("sf")) {
                Lang.COMMAND_KEY_GIVE_DONE.message().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        return true;
    }

    private static boolean setKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)arguments.get("key", CrateKey.class);
        int amount = arguments.getInt("amount", 1);
        if (amount <= 0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getString("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            plugin.getKeyManager().setKey((CrateUser)((Object)user), key, amount);
            plugin.getUserManager().save((AbstractUser)user);
            Player target = user.getPlayer();
            if (target != null && !context.hasFlag("s")) {
                Lang.COMMAND_KEY_SET_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
            if (!context.hasFlag("sf")) {
                Lang.COMMAND_KEY_SET_DONE.message().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        return true;
    }

    private static boolean takeKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)arguments.get("key", CrateKey.class);
        int amount = arguments.getInt("amount", 1);
        if (amount <= 0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getString("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            plugin.getKeyManager().takeKey((CrateUser)((Object)user), key, amount);
            plugin.getUserManager().save((AbstractUser)user);
            Player target = user.getPlayer();
            if (target != null && !context.hasFlag("s")) {
                Lang.COMMAND_KEY_TAKE_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
            if (!context.hasFlag("sf")) {
                Lang.COMMAND_KEY_TAKE_DONE.message().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        return true;
    }
}

