/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.event.CrateObtainRewardEvent;
import su.nightexpress.excellentcrates.api.event.CrateOpenEvent;
import su.nightexpress.excellentcrates.api.opening.Opening;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.crate.impl.Milestone;
import su.nightexpress.excellentcrates.crate.impl.OpenOptions;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.crate.limit.LimitValues;
import su.nightexpress.excellentcrates.crate.listener.CrateListener;
import su.nightexpress.excellentcrates.crate.menu.MilestonesMenu;
import su.nightexpress.excellentcrates.crate.menu.OpeningAmountMenu;
import su.nightexpress.excellentcrates.crate.menu.OpeningCostMenu;
import su.nightexpress.excellentcrates.crate.menu.PreviewMenu;
import su.nightexpress.excellentcrates.data.crate.GlobalCrateData;
import su.nightexpress.excellentcrates.data.crate.UserCrateData;
import su.nightexpress.excellentcrates.data.reward.RewardData;
import su.nightexpress.excellentcrates.hologram.HologramTemplate;
import su.nightexpress.excellentcrates.registry.CratesRegistries;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.excellentcrates.util.InteractType;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.excellentcrates.util.pos.WorldPos;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CrateManager
extends AbstractManager<CratesPlugin> {
    private final Map<String, Rarity> rarityByIdMap = new HashMap<String, Rarity>();
    private final Map<String, Crate> crateByIdMap = new HashMap<String, Crate>();
    private final Map<WorldPos, Crate> crateByPosMap = new HashMap<WorldPos, Crate>();
    private final Map<String, PreviewMenu> previewByIdMap = new HashMap<String, PreviewMenu>();
    private final Map<UUID, Long> previewCooldown = new HashMap<UUID, Long>();
    private OpeningCostMenu costMenu;
    private OpeningAmountMenu amountMenu;
    private MilestonesMenu milestonesMenu;

    public CrateManager(@NotNull CratesPlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.updateHologramTemplates();
        this.loadRarities();
        this.loadPreviews();
        this.loadCrates();
        this.loadUI();
        ((CratesPlugin)this.plugin).runTask(task -> this.reportProblems());
        this.addListener((SimpeListener)new CrateListener((CratesPlugin)this.plugin, this));
        this.addAsyncTask(this::playCrateEffects, 1L);
        this.addAsyncTask(this::saveCrates, (Integer)Config.CRATE_SAVE_INTERVAL.get());
    }

    protected void onShutdown() {
        this.saveCrates();
        if (this.milestonesMenu != null) {
            this.milestonesMenu.clear();
        }
        this.previewByIdMap.values().forEach(LinkedMenu::clear);
        this.previewByIdMap.clear();
        this.crateByIdMap.clear();
        this.crateByPosMap.clear();
        this.rarityByIdMap.clear();
    }

    private void updateHologramTemplates() {
        FileConfig config = ((CratesPlugin)this.plugin).getConfig();
        if (!config.contains("Crate.Holograms.Templates")) {
            return;
        }
        config.remove("Crate.Holograms.TemplateList");
        config.getSection("Crate.Holograms.Templates").forEach(sId -> {
            List text = config.getStringList("Crate.Holograms.Templates." + sId);
            HologramTemplate template = new HologramTemplate((String)sId, text);
            template.write(config, "Crate.Holograms.TemplateList." + sId);
        });
        config.remove("Crate.Holograms.Templates");
        Config.CRATE_HOLOGRAM_TEMPLATES.read(config);
    }

    private void loadRarities() {
        FileConfig config = ((CratesPlugin)this.plugin).getConfig();
        if (config.getSection("Rewards.Rarities").isEmpty()) {
            HashSet<Rarity> rarities = new HashSet<Rarity>();
            File oldFile = new File(((CratesPlugin)this.plugin).getDataFolder(), "rarity.yml");
            if (oldFile.exists()) {
                FileConfig oldConfig = new FileConfig(oldFile);
                for (String id : oldConfig.getSection("")) {
                    rarities.add(Rarity.read((CratesPlugin)this.plugin, oldConfig, id, id));
                }
                oldFile.delete();
            }
            if (rarities.isEmpty()) {
                rarities.add(new Rarity((CratesPlugin)this.plugin, "common", TagWrappers.WHITE.wrap("Common"), 70.0));
                rarities.add(new Rarity((CratesPlugin)this.plugin, "rare", TagWrappers.GREEN.wrap("Rare"), 25.0));
                rarities.add(new Rarity((CratesPlugin)this.plugin, "mythic", TagWrappers.SOFT_PURPLE.wrap("Mythic"), 5.0));
            }
            rarities.forEach(rarity -> rarity.write(config, "Rewards.Rarities." + rarity.getId()));
        }
        config.getSection("Rewards.Rarities").forEach(rarityId -> {
            Rarity rarity = Rarity.read((CratesPlugin)this.plugin, config, "Rewards.Rarities." + rarityId, rarityId);
            this.rarityByIdMap.put(rarity.getId(), rarity);
        });
        ((CratesPlugin)this.plugin).info("Loaded " + this.rarityByIdMap.size() + " rarities!");
    }

    private void loadPreviews() {
        File dir = new File(((CratesPlugin)this.plugin).getDataFolder().getAbsolutePath(), "/previews/");
        if (!dir.exists() && dir.mkdirs()) {
            new PreviewMenu((CratesPlugin)this.plugin, FileConfig.loadOrExtract((NightCorePlugin)this.plugin, (String)"/previews/", (String)"default.yml"));
        }
        for (FileConfig config : FileConfig.loadAll((String)(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/previews/"), (boolean)false)) {
            PreviewMenu menu = new PreviewMenu((CratesPlugin)this.plugin, config);
            String id = config.getFile().getName().replace(".yml", "").toLowerCase();
            this.previewByIdMap.put(id, menu);
        }
    }

    private void loadUI() {
        this.costMenu = (OpeningCostMenu)this.addMenu((Menu)new OpeningCostMenu((CratesPlugin)this.plugin, this), "/ui/", "crate_open_costs.yml");
        this.amountMenu = (OpeningAmountMenu)this.addMenu((Menu)new OpeningAmountMenu((CratesPlugin)this.plugin, this), "/ui/", "crate_open_amount.yml");
        if (Config.isMilestonesEnabled()) {
            this.milestonesMenu = new MilestonesMenu((CratesPlugin)this.plugin);
        }
    }

    private void loadCrates() {
        for (File file : FileUtil.getFiles((String)(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/crates/"), (boolean)false)) {
            String id = (String)Strings.varStyle((String)FileConfig.getName((File)file)).orElseThrow();
            Crate crate = new Crate((CratesPlugin)this.plugin, file.toPath(), id);
            this.loadCrate(crate);
        }
        ((CratesPlugin)this.plugin).info("Loaded " + this.crateByIdMap.size() + " crates.");
    }

    private void loadCrate(@NotNull Crate crate) {
        try {
            crate.load();
            this.crateByIdMap.put(crate.getId(), crate);
            this.addCratePositions(crate);
        }
        catch (IllegalStateException exception) {
            ((CratesPlugin)this.plugin).error("Crate '" + String.valueOf(crate.getPath()) + "' can not be loaded.");
            exception.printStackTrace();
        }
    }

    private void reportProblems() {
        this.getCrates().forEach(crate -> crate.collectProblems().print(((CratesPlugin)this.plugin).getLogger()));
    }

    private void saveCrates() {
        this.getCrates().forEach(Crate::saveIfDirty);
    }

    public int countCrates() {
        return this.crateByIdMap.size();
    }

    public boolean hasCrate(@NotNull String id) {
        return this.crateByIdMap.containsKey(id);
    }

    @NotNull
    public Map<String, Rarity> getRarityByIdMap() {
        return this.rarityByIdMap;
    }

    @NotNull
    public Set<Rarity> getRarities() {
        return new HashSet<Rarity>(this.rarityByIdMap.values());
    }

    @Nullable
    public Rarity getRarity(@NotNull String id) {
        return this.rarityByIdMap.get(id.toLowerCase());
    }

    @NotNull
    public Set<String> getRarityIds() {
        return new HashSet<String>(this.rarityByIdMap.keySet());
    }

    @NotNull
    public Rarity getMostCommonRarity() {
        return this.getRarities().stream().max(Comparator.comparing(Rarity::getWeight)).orElseThrow();
    }

    @NotNull
    public Map<String, PreviewMenu> getPreviewByIdMap() {
        return this.previewByIdMap;
    }

    @Nullable
    public PreviewMenu getPreviewById(@NotNull String id) {
        return this.previewByIdMap.get(id.toLowerCase());
    }

    @NotNull
    public Set<PreviewMenu> getPreviews() {
        return new HashSet<PreviewMenu>(this.previewByIdMap.values());
    }

    @NotNull
    public List<String> getPreviewNames() {
        return new ArrayList<String>(this.previewByIdMap.keySet());
    }

    public void openMilestones(@NotNull Player player, @NotNull CrateSource source) {
        if (this.milestonesMenu != null) {
            this.milestonesMenu.open(player, source);
        }
    }

    @NotNull
    public List<String> getCrateIds() {
        return new ArrayList<String>(this.crateByIdMap.keySet());
    }

    @NotNull
    public Map<String, Crate> getCratesMap() {
        return this.crateByIdMap;
    }

    @NotNull
    public Set<Crate> getCrates() {
        return new HashSet<Crate>(this.crateByIdMap.values());
    }

    public boolean isCrate(@NotNull ItemStack item) {
        return this.getCrateByItem(item) != null;
    }

    @Nullable
    public Crate getCrateById(@NotNull String id) {
        return this.crateByIdMap.get(id.toLowerCase());
    }

    @Nullable
    public Crate getCrateByItem(@NotNull ItemStack item) {
        String id = PDCUtil.getString((ItemStack)item, (NamespacedKey)Keys.crateId).orElse(null);
        return id != null ? this.getCrateById(id) : null;
    }

    @Nullable
    public Crate getCrateByBlock(@NotNull Block block) {
        return this.getCrateByLocation(block.getLocation());
    }

    @Nullable
    public Crate getCrateByLocation(@NotNull Location location) {
        WorldPos pos = WorldPos.from(location);
        return this.crateByPosMap.get(pos);
    }

    public void removeCratePositions(@NotNull Crate crate) {
        crate.getBlockPositions().forEach(this.crateByPosMap::remove);
    }

    public void addCratePositions(@NotNull Crate crate) {
        crate.getBlockPositions().forEach(pos -> this.crateByPosMap.put((WorldPos)pos, crate));
    }

    public void createCrate(@NotNull String id) {
        Path path = Path.of(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/crates/", FileConfig.withExtension((String)id));
        FileUtil.createFileIfNotExists((Path)path);
        Crate crate = new Crate((CratesPlugin)this.plugin, path, id);
        crate.setName(StringUtil.capitalizeUnderscored((String)id) + " Crate");
        crate.setDescription(new ArrayList<String>());
        crate.setItem(ItemHelper.vanilla(CrateUtils.getDefaultItem(crate)));
        crate.setOpeningEnabled(true);
        crate.setOpeningId("default");
        crate.setPreviewEnabled(true);
        crate.setPreviewId("default");
        crate.setPushbackEnabled(true);
        crate.setHologramEnabled(true);
        crate.setHologramTemplateId("default");
        crate.setEffectType("helix");
        crate.setEffectParticle(UniParticle.of((Particle)Particle.CLOUD));
        crate.saveForce();
        this.loadCrate(crate);
    }

    public boolean delete(@NotNull Crate crate) {
        try {
            if (!Files.deleteIfExists(crate.getPath())) {
                return false;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
        crate.removeHologram();
        ((CratesPlugin)this.plugin).getDataManager().handleCrateRemoval(crate);
        this.crateByIdMap.remove(crate.getId());
        this.crateByPosMap.values().removeIf(stored -> stored == crate);
        return true;
    }

    public void giveLinkTool(@NotNull Player player, @NotNull Crate crate) {
        ItemStack itemStack = ((NightItem)Config.CRATE_LINK_TOOL.get()).getItemStack();
        PDCUtil.set((ItemStack)itemStack, (NamespacedKey)Keys.linkToolCrateId, (String)crate.getId());
        Players.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack});
    }

    public boolean handleLinkToolInteraction(@NotNull Player player, @NotNull Block block, @NotNull ItemStack itemStack, @NotNull PlayerInteractEvent event) {
        String crateId = PDCUtil.getString((ItemStack)itemStack, (NamespacedKey)Keys.linkToolCrateId).orElse(null);
        if (crateId == null) {
            return false;
        }
        itemStack.setAmount(0);
        event.setUseItemInHand(Event.Result.DENY);
        event.setUseInteractedBlock(Event.Result.DENY);
        Crate crate = this.getCrateById(crateId);
        if (crate != null) {
            crate.clearBlockPositions();
            crate.addBlockPosition(block.getLocation());
            crate.recreateHologram();
            crate.markDirty();
            ((CratesPlugin)this.plugin).getEditorManager().openOptionsMenu(player, crate);
        }
        return true;
    }

    public boolean dropCrateItem(@NotNull Crate crate, @NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        world.dropItemNaturally(location, crate.getItemStack());
        return true;
    }

    public void giveCrateItem(@NotNull Player player, @NotNull Crate crate, int amount) {
        amount = Math.max(1, amount);
        ItemStack crateItem = crate.getItemStack();
        Players.addItem((Player)player, (ItemStack)crateItem, (int)amount);
    }

    public void openCostMenu(@NotNull Player player, @NotNull CrateSource source) {
        this.costMenu.open(player, source);
    }

    public void openAmountMenu(@NotNull Player player, @NotNull CrateSource source, @Nullable Cost cost) {
        this.amountMenu.open(player, source, cost);
    }

    public void previewCrate(@NotNull Player player, @NotNull CrateSource source) {
        Crate crate = source.getCrate();
        if (!crate.isPreviewEnabled()) {
            return;
        }
        PreviewMenu menu = this.getPreviewById(crate.getPreviewId());
        if (menu == null) {
            return;
        }
        menu.open(player, source);
    }

    public void interactCrate(@NotNull Player player, @NotNull Crate crate, @NotNull InteractType action, @Nullable ItemStack item, @Nullable Block block) {
        CrateSource source = new CrateSource(crate, item, block);
        if (action == InteractType.CRATE_PREVIEW) {
            this.previewCrate(player, source);
            return;
        }
        this.preOpenCrate(player, source);
    }

    public void preOpenCrate(@NotNull Player player, @NotNull CrateSource source) {
        Crate crate = source.getCrate();
        if (!this.testRestrictions(player, crate)) {
            this.pushback(player, source);
            return;
        }
        if (!crate.hasCost()) {
            if (((Boolean)Config.MASS_OPENING_ALLOW_FOR_NO_COST.get()).booleanValue()) {
                this.openAmountMenu(player, source, null);
            } else {
                this.openCrate(player, source, OpenOptions.empty(), null);
            }
            return;
        }
        this.costMenu.open(player, source);
    }

    public void multiOpenCrate(@NotNull Player player, @NotNull CrateSource source, @NotNull OpenOptions options, @Nullable Cost cost, int amount) {
        int massLimit = (Integer)Config.MASS_OPENING_LIMIT.get();
        int openings = Math.clamp((long)amount, 1, massLimit);
        options.add(OpenOptions.Option.IGNORE_ANIMATION);
        for (int spent = 0; spent < openings && this.openCrate(player, source, options, cost); ++spent) {
        }
    }

    private boolean testRestrictions(@NotNull Player player, @NotNull Crate crate) {
        if (!((CratesPlugin)this.plugin).getDataManager().isDataLoaded()) {
            return false;
        }
        if (!((CratesPlugin)this.plugin).getOpeningManager().isOpeningAvailable(player)) {
            Lang.CRATE_OPEN_ERROR_ALREADY.message().send((CommandSender)player);
            return false;
        }
        if (player.getInventory().firstEmpty() == -1) {
            Lang.CRATE_OPEN_ERROR_INVENTORY_SPACE.message().send((CommandSender)player);
            return false;
        }
        if (crate.getRewards(player).isEmpty()) {
            Lang.CRATE_OPEN_ERROR_NO_REWARDS.message().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()));
            return false;
        }
        return true;
    }

    public boolean openCrate(@NotNull Player player, @NotNull CrateSource source, @NotNull OpenOptions options, @Nullable Cost cost) {
        ItemStack item;
        Cost realCost;
        Crate crate = source.getCrate();
        CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
        UserCrateData crateData = user.getCrateData(crate);
        Cost cost2 = realCost = options.has(OpenOptions.Option.IGNORE_COST) ? null : cost;
        if (!this.testRestrictions(player, crate)) {
            this.pushback(player, source);
            return false;
        }
        if (source.getItem() != null && source.getItem().getAmount() <= 0) {
            return false;
        }
        if (!options.has(OpenOptions.Option.IGNORE_PERMISSION) && !crate.hasPermission(player)) {
            CoreLang.ERROR_NO_PERMISSION.withPrefix((NightPlugin)this.plugin).send((CommandSender)player);
            this.pushback(player, source);
            return false;
        }
        if (!options.has(OpenOptions.Option.IGNORE_COOLDOWN) && crate.isOpeningCooldownEnabled() && crateData.hasCooldown()) {
            (crateData.isCooldownPermanent() ? Lang.CRATE_OPEN_ERROR_COOLDOWN_ONE_TIMED : Lang.CRATE_OPEN_ERROR_COOLDOWN_TEMPORARY).message().send((CommandSender)player, replacer -> replacer.replace("%time%", (Object)TimeFormats.formatDuration((long)crateData.getOpenCooldown(), (TimeFormatType)TimeFormatType.LITERAL)).replace(crate.replacePlaceholders()));
            this.pushback(player, source);
            return false;
        }
        if (realCost != null && !realCost.canAfford(player)) {
            Lang.CRATE_OPEN_TOO_EXPENSIVE.message().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()).replace("%costs%", () -> realCost.formatInline(", ")));
            this.pushback(player, source);
            return false;
        }
        CrateOpenEvent openEvent = new CrateOpenEvent(crate, player);
        ((CratesPlugin)this.plugin).getPluginManager().callEvent((Event)openEvent);
        if (openEvent.isCancelled()) {
            this.pushback(player, source);
            return false;
        }
        player.closeInventory();
        Opening opening = ((CratesPlugin)this.plugin).getOpeningManager().createOpening(player, source, realCost);
        ((CratesPlugin)this.plugin).getOpeningManager().startOpening(player, opening, options.has(OpenOptions.Option.IGNORE_ANIMATION));
        if (realCost != null) {
            realCost.takeAll(player);
        }
        if ((item = source.getItem()) != null) {
            item.setAmount(item.getAmount() - 1);
        }
        return true;
    }

    private void pushback(@NotNull Player player, @NotNull CrateSource source) {
        if (source.hasBlock() && source.getCrate().isPushbackEnabled()) {
            player.setVelocity(player.getEyeLocation().getDirection().setY(((Double)Config.CRATE_PUSHBACK_Y.get()).doubleValue()).multiply(((Double)Config.CRATE_PUSHBACK_MULTIPLY.get()).doubleValue()));
        }
    }

    public boolean triggerMilestones(@NotNull Player player, @NotNull Crate crate, int progress) {
        if (!crate.hasMilestones()) {
            return false;
        }
        int maxProgress = crate.getMaxMilestone();
        if (!crate.isMilestonesRepeatable() && progress > maxProgress) {
            return false;
        }
        Milestone milestone = crate.getMilestone(progress);
        if (milestone == null) {
            return false;
        }
        Reward reward = milestone.getReward();
        if (reward == null) {
            return false;
        }
        reward.giveContent(player);
        Lang.CRATE_OPEN_MILESTONE_COMPLETED.message().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()).replace("%milestone_openings%", (Object)NumberUtil.format((double)progress)).replace(reward.replacePlaceholders()));
        return true;
    }

    public void giveReward(@NotNull Player player, @NotNull Reward reward) {
        reward.giveContent(player);
        Crate crate = reward.getCrate();
        GlobalCrateData globalData = ((CratesPlugin)this.plugin).getDataManager().getCrateDataOrCreate(crate);
        globalData.setLatestReward(reward);
        globalData.setSaveRequired(true);
        if (reward.isBroadcast()) {
            Lang.CRATE_OPEN_REWARD_BROADCAST.message().broadcast(replacer -> replacer.replace(Placeholders.forPlayerWithPAPI((Player)player)).replace(crate.replacePlaceholders()).replace(reward.replacePlaceholders()));
        }
        this.addRollCount(player, reward);
        ((CratesPlugin)this.plugin).getCrateLogger().logReward(player, reward);
        CrateObtainRewardEvent event = new CrateObtainRewardEvent(reward, player);
        ((CratesPlugin)this.plugin).getPluginManager().callEvent((Event)event);
    }

    public void addRollCount(@NotNull Player player, @NotNull Reward reward) {
        LimitValues limits = reward.getLimits();
        if (!limits.isEnabled()) {
            return;
        }
        RewardData globalData = ((CratesPlugin)this.plugin).getDataManager().getRewardLimitOrCreate(reward, null);
        RewardData playerData = ((CratesPlugin)this.plugin).getDataManager().getRewardLimitOrCreate(reward, player);
        if (limits.hasGlobalCooldown()) {
            globalData.setCooldownUntil(limits.generateGlobalCooldown());
            globalData.addRoll(1);
            globalData.setSaveRequired(true);
        }
        if (limits.hasPlayerCooldown()) {
            playerData.setCooldownUntil(limits.generatePlayerCooldown());
            playerData.addRoll(1);
            playerData.setSaveRequired(true);
        }
    }

    public void setPreviewCooldown(@NotNull Player player) {
        long timestamp = System.currentTimeMillis() + (Long)Config.CRATE_PREVIEW_COOLDOWN.get();
        this.previewCooldown.put(player.getUniqueId(), timestamp);
    }

    public long getPreviewCooldown(@NotNull Player player) {
        long timestamp = this.previewCooldown.getOrDefault(player.getUniqueId(), 0L);
        if (System.currentTimeMillis() < timestamp) {
            return timestamp;
        }
        this.removePreviewCooldown(player);
        return 0L;
    }

    public boolean hasPreviewCooldown(@NotNull Player player) {
        return this.getPreviewCooldown(player) > 0L;
    }

    public void removePreviewCooldown(@NotNull Player player) {
        this.previewCooldown.remove(player.getUniqueId());
    }

    public void playCrateEffects() {
        this.getCrates().forEach(crate -> {
            CrateEffect effect = crate.getEffect();
            if (effect.isDummy()) {
                return;
            }
            UniParticle particle = crate.getEffectParticle();
            crate.getBlockPositions().forEach(worldPos -> {
                if (!worldPos.isChunkLoaded()) {
                    return;
                }
                Location location = worldPos.toLocation();
                if (location == null) {
                    return;
                }
                CrateUtils.getPlayersForEffects(location).forEach(player -> effect.playStep(location, particle, (Player)player));
            });
        });
        CratesRegistries.getEffects().forEach(CrateEffect::addTickCount);
    }
}

