/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.cost.type.impl;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.crate.cost.entry.impl.KeyCostEntry;
import su.nightexpress.excellentcrates.crate.cost.type.AbstractCostType;
import su.nightexpress.excellentcrates.key.KeyManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class KeyCostType
extends AbstractCostType
implements LangContainer {
    private static final TextLocale LOCALE_NAME = LangEntry.builder((String)"Costs.Key.Name").text(TagWrappers.YELLOW.wrap("[\ud83d\udd11]") + " " + TagWrappers.WHITE.wrap("Key"));
    public static final TextLocale LOCALE_FORMAT = LangEntry.builder((String)"Costs.Key.Format").text(TagWrappers.GRAY.wrap("x%amount% %name%"));
    public static final IconLocale LOCALE_EDIT_BUTTON = LangEntry.iconBuilder((String)"Costs.Key.EditButton").rawName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Key Cost") + TagWrappers.GRAY.wrap(" - ") + TagWrappers.WHITE.wrap("%name%")).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("Press " + TagWrappers.SOFT_RED.wrap((String)TagWrappers.KEY.apply("key.drop")) + " key to delete.")}).br().appendCurrent("Key ID", "%id%").appendCurrent("Amount", "%amount%").br().appendClick("Click to edit", (TagWrapper)TagWrappers.YELLOW).build();
    private final KeyManager keyManager;

    public KeyCostType(@NotNull CratesPlugin plugin, @NotNull KeyManager keyManager) {
        super("key");
        plugin.injectLang(this);
        this.keyManager = keyManager;
    }

    @Override
    public boolean isAvailable() {
        return this.keyManager.hasKeys();
    }

    @Override
    @NotNull
    public String getName() {
        return LOCALE_NAME.text();
    }

    @Override
    @NotNull
    public KeyCostEntry load(@NotNull FileConfig config, @NotNull String path) {
        String keyId = (String)ConfigValue.create((String)(path + ".Key"), (String)"null", (String[])new String[0]).read(config);
        int amount = (Integer)ConfigValue.create((String)(path + ".Amount"), (int)1, (String[])new String[0]).read(config);
        return new KeyCostEntry(this, this.keyManager, keyId, amount);
    }

    @Override
    @NotNull
    public KeyCostEntry createEmpty() {
        return new KeyCostEntry(this, this.keyManager, "null", 0);
    }
}

