/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.limit;

import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.limit.CooldownMode;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.TimeUtil;

public class LimitValues
implements Writeable {
    private static final int UNLIMITED = -1;
    private boolean enabled;
    private CooldownMode cooldownType;
    private int globalAmount;
    private int playerAmount;
    private long globalCooldown;
    private long playerCooldown;

    public LimitValues(boolean enabled, @NotNull CooldownMode cooldownType, int globalAmount, int playerAmount, long globalCooldown, long playerCooldown) {
        this.setEnabled(enabled);
        this.setCooldownType(cooldownType);
        this.setGlobalAmount(globalAmount);
        this.setPlayerAmount(playerAmount);
        this.setGlobalCooldown(globalCooldown);
        this.setPlayerCooldown(playerCooldown);
    }

    @NotNull
    public static LimitValues unlimited() {
        return new LimitValues(false, CooldownMode.DAILY, -1, -1, 0L, 0L);
    }

    @NotNull
    public static LimitValues read(@NotNull FileConfig config, @NotNull String path) {
        boolean enabled = (Boolean)ConfigValue.create((String)(path + ".Enabled"), (boolean)false, (String[])new String[0]).read(config);
        CooldownMode cooldownType = (CooldownMode)((Object)ConfigValue.create((String)(path + ".CooldownType"), CooldownMode.class, (Enum)CooldownMode.DAILY, (String[])new String[0]).read(config));
        int globalAmount = (Integer)ConfigValue.create((String)(path + ".GlobalAmount"), (int)-1, (String[])new String[0]).read(config);
        int playerAmount = (Integer)ConfigValue.create((String)(path + ".PlayerAmount"), (int)-1, (String[])new String[0]).read(config);
        long globalCooldown = (Long)ConfigValue.create((String)(path + ".GlobalCooldown"), (long)0L, (String[])new String[0]).read(config);
        long playerCooldown = (Long)ConfigValue.create((String)(path + ".PlayerCooldown"), (long)0L, (String[])new String[0]).read(config);
        return new LimitValues(enabled, cooldownType, globalAmount, playerAmount, globalCooldown, playerCooldown);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Enabled", (Object)this.enabled);
        config.set(path + ".CooldownType", (Object)this.cooldownType.name());
        config.set(path + ".GlobalAmount", (Object)this.globalAmount);
        config.set(path + ".PlayerAmount", (Object)this.playerAmount);
        config.set(path + ".GlobalCooldown", (Object)this.globalCooldown);
        config.set(path + ".PlayerCooldown", (Object)this.playerCooldown);
    }

    public long generateGlobalCooldown() {
        return this.createCooldownTimestamp(this.globalCooldown);
    }

    public long generatePlayerCooldown() {
        return this.createCooldownTimestamp(this.playerCooldown);
    }

    private long createCooldownTimestamp(long cooldown) {
        return switch (this.cooldownType) {
            default -> throw new MatchException(null, null);
            case CooldownMode.CUSTOM -> TimeUtil.createFutureTimestamp((double)cooldown);
            case CooldownMode.DAILY -> TimeUtil.toEpochMillis((LocalDateTime)LocalDateTime.of(TimeUtil.getCurrentDate().plusDays(1L), LocalTime.MIDNIGHT));
        };
    }

    public boolean isGlobalAmountLimited() {
        return this.globalAmount > -1;
    }

    public boolean isPlayerAmountLimited() {
        return this.playerAmount > -1;
    }

    public boolean hasGlobalCooldown() {
        return this.globalCooldown > 0L;
    }

    public boolean hasPlayerCooldown() {
        return this.playerCooldown > 0L;
    }

    public boolean isAmountLimited() {
        return this.isGlobalAmountLimited() || this.isPlayerAmountLimited();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public CooldownMode getCooldownType() {
        return this.cooldownType;
    }

    public void setCooldownType(@NotNull CooldownMode cooldownType) {
        this.cooldownType = cooldownType;
    }

    public int getGlobalAmount() {
        return this.globalAmount;
    }

    public void setGlobalAmount(int globalAmount) {
        this.globalAmount = globalAmount;
    }

    public int getPlayerAmount() {
        return this.playerAmount;
    }

    public void setPlayerAmount(int playerAmount) {
        this.playerAmount = playerAmount;
    }

    public long getGlobalCooldown() {
        return this.globalCooldown;
    }

    public void setGlobalCooldown(long globalCooldown) {
        this.globalCooldown = Math.max(0L, globalCooldown);
    }

    public long getPlayerCooldown() {
        return this.playerCooldown;
    }

    public void setPlayerCooldown(long playerCooldown) {
        this.playerCooldown = Math.max(0L, playerCooldown);
    }
}

