/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.listener;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.CrateManager;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.util.ClickType;
import su.nightexpress.excellentcrates.util.InteractType;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;

public class CrateListener
extends AbstractListener<CratesPlugin> {
    private final CrateManager manager;
    private final Set<UUID> adventureFix;

    public CrateListener(@NotNull CratesPlugin plugin, @NotNull CrateManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
        this.adventureFix = new HashSet<UUID>();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.manager.removePreviewCooldown(player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCrateUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        Action action = event.getAction();
        Block block = event.getClickedBlock();
        Crate crate = null;
        if (item != null && !item.getType().isAir()) {
            if (block != null && this.manager.handleLinkToolInteraction(player, block, item, event)) {
                return;
            }
            crate = this.manager.getCrateByItem(item);
        }
        if (crate == null) {
            item = null;
            if (block == null) {
                return;
            }
            crate = this.manager.getCrateByBlock(block);
        }
        if (crate == null) {
            return;
        }
        event.setUseItemInHand(Event.Result.DENY);
        if (player.getGameMode() != GameMode.ADVENTURE || action == Action.RIGHT_CLICK_BLOCK) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ClickType clickType = ClickType.from(action, player.isSneaking());
        InteractType clickAction = Config.getCrateClickAction(clickType);
        if (clickAction == null) {
            return;
        }
        if (player.getGameMode() == GameMode.ADVENTURE && block != null && block.getType().isInteractable()) {
            if (action == Action.RIGHT_CLICK_BLOCK) {
                this.adventureFix.add(player.getUniqueId());
            } else if (action == Action.LEFT_CLICK_BLOCK && this.adventureFix.remove(player.getUniqueId())) {
                return;
            }
        }
        if (clickAction == InteractType.CRATE_PREVIEW && crate.isPreviewEnabled()) {
            if (this.manager.hasPreviewCooldown(player)) {
                Lang.CRATE_PREVIEW_ERROR_COOLDOWN.message().send((CommandSender)player, replacer -> replacer.replace("%time%", (Object)TimeFormats.formatDuration((long)this.manager.getPreviewCooldown(player), (TimeFormatType)TimeFormatType.LITERAL)));
                return;
            }
            this.manager.setPreviewCooldown(player);
        }
        this.manager.interactCrate(player, crate, clickAction, item, block);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onCratePlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (this.manager.isCrate(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCrateAnvilStop(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        if (first != null && this.manager.isCrate(first) || second != null && this.manager.isCrate(second)) {
            event.setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCrateCraftStop(CraftItemEvent event) {
        CraftingInventory inventory = event.getInventory();
        if (Stream.of(inventory.getMatrix()).anyMatch(item -> item != null && this.manager.isCrate((ItemStack)item))) {
            event.setCancelled(true);
        }
    }
}

