/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.menu;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.CrateManager;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.crate.impl.OpenOptions;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class OpeningCostMenu
extends LinkedMenu<CratesPlugin, CrateSource>
implements ConfigBased {
    private final CrateManager manager;
    private final Map<Integer, int[]> slotsByCostsAmount;

    public OpeningCostMenu(@NotNull CratesPlugin plugin, @NotNull CrateManager manager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X3, TagWrappers.BLACK.wrap("[%crate_name%] Select a Cost"));
        this.manager = manager;
        this.slotsByCostsAmount = new HashMap<Integer, int[]>();
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        return (String)((CrateSource)this.getLink(viewer)).getCrate().replacePlaceholders().apply(super.getTitle(viewer));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        CrateSource source = (CrateSource)this.getLink(player);
        Crate crate = source.getCrate();
        List<Cost> costs = crate.getCosts();
        int costCount = costs.size();
        int[] costSlots = this.slotsByCostsAmount.getOrDefault(costCount, new int[0]);
        for (int index = 0; index < costCount && index < costSlots.length; ++index) {
            Cost cost = costs.get(index);
            int slot = costSlots[index];
            int maxOpenings = cost.countMaxOpenings(player);
            viewer.addItem(NightItem.fromItemStack((ItemStack)cost.getIconStack()).localized(maxOpenings > 0 ? Lang.UI_COSTS_OPTION_AVAILABLE : Lang.UI_COSTS_OPTION_UNAVAILABLE).replacement(replacer -> replacer.replace(crate.replacePlaceholders()).replace(cost.replacePlaceholders()).replace("%costs%", () -> OpeningCostMenu.formatCostEntries(cost, player)).replace("%available%", (Object)String.valueOf(maxOpenings))).toMenuItem().setPriority(Integer.MAX_VALUE).setSlots(new int[]{slot}).setHandler((viewer1, event) -> this.runNextTick(() -> {
                if (maxOpenings > 1 && Config.isMassOpenEnabled()) {
                    this.manager.openAmountMenu(player, source, cost);
                    return;
                }
                player.closeInventory();
                this.manager.openCrate(player, source, OpenOptions.empty(), cost);
            })).build());
        }
    }

    @NotNull
    private static String formatCostEntries(@NotNull Cost cost, @NotNull Player player) {
        return cost.getEntries().stream().map(costEntry -> {
            boolean canAfford = costEntry.hasEnough(player);
            return (canAfford ? Lang.UI_COSTS_ENTRY_AVAILABLE : Lang.UI_COSTS_ENTRY_UNAVAILABLE).text().replace("%entry%", costEntry.format());
        }).collect(Collectors.joining(TagWrappers.BR));
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.slotsByCostsAmount.clear();
        for (int count = 0; count < 10; ++count) {
            int amount = count + 1;
            int[] defSlots = OpeningCostMenu.getDefaultSlots(amount);
            int[] skillSlots = (int[])ConfigValue.create((String)("Cost.SlotsByCount." + amount), (int[])defSlots, (String[])new String[0]).read(config);
            this.slotsByCostsAmount.put(amount, skillSlots);
        }
        loader.addDefaultItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setPriority(-1).setSlots(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}));
        loader.addDefaultItem(NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setPriority(-1).setSlots(new int[]{10, 11, 12, 13, 14, 15, 16}));
    }

    private static int[] getDefaultSlots(int count) {
        int[] nArray;
        switch (count) {
            case 1: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 13;
                break;
            }
            case 2: {
                int[] nArray3 = new int[2];
                nArray3[0] = 12;
                nArray = nArray3;
                nArray3[1] = 14;
                break;
            }
            case 3: {
                int[] nArray4 = new int[3];
                nArray4[0] = 11;
                nArray4[1] = 13;
                nArray = nArray4;
                nArray4[2] = 15;
                break;
            }
            case 4: {
                int[] nArray5 = new int[4];
                nArray5[0] = 10;
                nArray5[1] = 12;
                nArray5[2] = 14;
                nArray = nArray5;
                nArray5[3] = 16;
                break;
            }
            case 5: {
                int[] nArray6 = new int[5];
                nArray6[0] = 11;
                nArray6[1] = 12;
                nArray6[2] = 13;
                nArray6[3] = 14;
                nArray = nArray6;
                nArray6[4] = 15;
                break;
            }
            case 6: {
                int[] nArray7 = new int[6];
                nArray7[0] = 10;
                nArray7[1] = 11;
                nArray7[2] = 12;
                nArray7[3] = 14;
                nArray7[4] = 15;
                nArray = nArray7;
                nArray7[5] = 16;
                break;
            }
            case 7: {
                int[] nArray8 = new int[7];
                nArray8[0] = 10;
                nArray8[1] = 11;
                nArray8[2] = 12;
                nArray8[3] = 13;
                nArray8[4] = 14;
                nArray8[5] = 15;
                nArray = nArray8;
                nArray8[6] = 16;
                break;
            }
            default: {
                nArray = new int[]{};
            }
        }
        return nArray;
    }
}

