/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.cost;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.cost.CostEntry;
import su.nightexpress.excellentcrates.api.cost.CostType;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.excellentcrates.registry.CratesRegistries;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CostEntryCreationDialog
extends CrateDialog<Cost> {
    private static final String ACTION_TYPE = "type";
    private static final String JSON_ID = "id";
    private static final TextLocale TITLE = TextLocale.builder((String)"Dialog.CostEntry.Creation.Title").text(CostEntryCreationDialog.title("Cost Entry", "Creation"));
    private static final DialogElementLocale BODY = DialogElementLocale.builder((String)"Dialog.CostEntry.Creation.Body").dialogElement(400, new String[]{"Select a cost type."});
    private static final DialogElementLocale BODY_EMPTY = DialogElementLocale.builder((String)"Dialog.CostEntry.Creation.BodyEmpty").dialogElement(400, new String[]{TagWrappers.SOFT_RED.and((TagWrapper)TagWrappers.UNDERLINED).wrap("NO AVAILABLE COST TYPES"), "", "You may see this message for one of the following reasons:", "", TagWrappers.SOFT_RED.wrap("\u2192") + " The " + TagWrappers.SOFT_RED.wrap("Keys") + " module is unavailable or has no keys created. You can create keys using the ExcellentCrates editor.", "", TagWrappers.SOFT_RED.wrap("\u2192") + " No supported " + TagWrappers.SOFT_RED.wrap("economy") + " or " + TagWrappers.SOFT_RED.wrap("currency") + " plugins are installed, or their integration is disabled in the main " + TagWrappers.SOFT_RED.wrap("nightcore") + " configuration file."});

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Cost cost) {
        ArrayList buttons = new ArrayList();
        Set<CostType> costTypes = CratesRegistries.getAvailableCostTypes();
        costTypes.stream().sorted(Comparator.comparing(CostType::getId)).forEach(costType -> {
            NightNbtHolder nbtHolder = NightNbtHolder.builder().put(JSON_ID, costType.getId()).build();
            buttons.add(DialogButtons.action((String)costType.getName()).action((WrappedDialogAction)DialogActions.customClick((String)ACTION_TYPE, (NightNbtHolder)nbtHolder)).build());
        });
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)(costTypes.isEmpty() ? BODY_EMPTY : BODY))}).build());
            if (!costTypes.isEmpty()) {
                builder.type((WrappedDialogType)DialogTypes.multiAction((List)buttons).exitAction(DialogButtons.back()).build());
            } else {
                builder.type((WrappedDialogType)DialogTypes.notice((WrappedActionButton)DialogButtons.back()));
            }
            builder.handleResponse(ACTION_TYPE, (user, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String id = nbtHolder.getText(JSON_ID).orElse(null);
                if (id == null) {
                    return;
                }
                CostType type = (CostType)CratesRegistries.COST_TYPE.byKey(id);
                if (type == null) {
                    return;
                }
                CostEntry entry = type.createEmpty();
                cost.addEntry(entry);
                user.callback();
                entry.openEditor(player, user.getCallback());
            });
        });
    }
}

