/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.crate;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CrateCooldownDialog
extends CrateDialog<Crate> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Crate.OpeningCooldown.Title").text(CrateCooldownDialog.title("Crate", "Opening Cooldown"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Crate.OpeningCooldown.Body").dialogElement(400, new String[]{"Enter the crate " + TagWrappers.SOFT_YELLOW.wrap("opening cooldown") + " time.", "The cooldown applies to " + TagWrappers.SOFT_YELLOW.wrap("the player") + " who opened the crate.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " To disable the cooldown, uncheck the " + TagWrappers.SOFT_YELLOW.wrap("Enabled") + " box."});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Dialog.Crate.Preview.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_COOLDOWN = LangEntry.builder((String)"Dialog.Crate.OpeningCooldown.Input.Cooldown").text("Opening Cooldown " + TagWrappers.GRAY.wrap("(in seconds)"));
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_COOLDOWN = "cooldown";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(crate.isOpeningCooldownEnabled()).build(), DialogInputs.text((String)JSON_COOLDOWN, (TextLocale)INPUT_COOLDOWN).initial(String.valueOf(crate.getOpeningCooldownTime())).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, crate.isOpeningCooldownEnabled());
                int cooldown = nbtHolder.getInt(JSON_COOLDOWN, crate.getOpeningCooldownTime());
                crate.setOpeningCooldownEnabled(enabled);
                crate.setOpeningCooldownTime(cooldown);
                crate.markDirty();
                viewer.callback();
            });
        });
    }
}

