/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.limit.CooldownMode;
import su.nightexpress.excellentcrates.crate.limit.LimitValues;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardLimitsDialog
extends CrateDialog<Reward> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Reward.Limits.Title").text(RewardLimitsDialog.title("Reward", "Limits"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Reward.Limits.Body").dialogElement(400, new String[]{"Here you can set how often and how many times this reward can be won.", "", TagWrappers.SOFT_ORANGE.wrap("Global") + " settings apply to all players at once, while the " + TagWrappers.SOFT_BLUE.wrap("Individual") + " ones apply individually.", "", (String)TagWrappers.SPRITE_NO_ATLAS.apply("item/clock_00") + " Use " + TagWrappers.SOFT_YELLOW.wrap("Daily") + " cooldown mode to reset the cooldown at " + TagWrappers.SOFT_YELLOW.wrap("midnight") + " after the specified number of days.", (String)TagWrappers.SPRITE_NO_ATLAS.apply("item/clock_00") + " Use " + TagWrappers.SOFT_YELLOW.wrap("Custom") + " cooldown mode to set an exact cooldown time in " + TagWrappers.SOFT_YELLOW.wrap("seconds") + ".", "", (String)TagWrappers.SPRITE_NO_ATLAS.apply("item/barrier") + " To disable cooldown, set it's value to " + TagWrappers.SOFT_RED.wrap("0") + ".", (String)TagWrappers.SPRITE_NO_ATLAS.apply("item/barrier") + " To remove the rolls limit, set it's value to " + TagWrappers.SOFT_RED.wrap("-1") + "."});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Dialog.Reward.Limits.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_COOLDOWN_MODE = LangEntry.builder((String)"Dialog.Reward.Limits.Input.CooldownMode").text(TagWrappers.SOFT_YELLOW.wrap("Cooldown Mode"));
    private static final TextLocale INPUT_GLOBAL_AMOUNT = LangEntry.builder((String)"Dialog.Reward.Limits.Input.GlobalAmount").text(TagWrappers.SOFT_ORANGE.wrap("(Global)") + " Max. Rolls");
    private static final TextLocale INPUT_GLOBAL_COOLDOWN = LangEntry.builder((String)"Dialog.Reward.Limits.Input.GlobalCooldown").text(TagWrappers.SOFT_ORANGE.wrap("(Global)") + " Cooldown");
    private static final TextLocale INPUT_PLAYER_AMOUNT = LangEntry.builder((String)"Dialog.Reward.Limits.Input.PlayerAmount").text(TagWrappers.SOFT_BLUE.wrap("(Individual)") + " Max. Rolls");
    private static final TextLocale INPUT_PLAYER_COOLDOWN = LangEntry.builder((String)"Dialog.Reward.Limits.Input.PlayerCooldown").text(TagWrappers.SOFT_BLUE.wrap("(Individual)") + " Cooldown");
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_COOLDOWN_MODE = "cooldown_mode";
    private static final String JSON_GLOBAL_AMOUNT = "g_amount";
    private static final String JSON_GLOBAL_COOLDOWN = "g_cooldown";
    private static final String JSON_PLAYER_AMOUNT = "p_amount";
    private static final String JSON_PLAYER_COOLDOWN = "p_cooldown";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Reward reward) {
        LimitValues limits = reward.getLimits();
        ArrayList<WrappedSingleOptionEntry> types = new ArrayList<WrappedSingleOptionEntry>();
        for (CooldownMode type : CooldownMode.values()) {
            types.add(new WrappedSingleOptionEntry(type.id(), Lang.COOLDOWN_MODE.getLocalized((Enum)type), limits.getCooldownType() == type));
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(limits.isEnabled()).build(), DialogInputs.singleOption((String)JSON_COOLDOWN_MODE, (TextLocale)INPUT_COOLDOWN_MODE, (List)types).build(), DialogInputs.text((String)JSON_GLOBAL_AMOUNT, (TextLocale)INPUT_GLOBAL_AMOUNT).initial(String.valueOf(limits.getGlobalAmount())).maxLength(7).build(), DialogInputs.text((String)JSON_GLOBAL_COOLDOWN, (TextLocale)INPUT_GLOBAL_COOLDOWN).initial(String.valueOf(limits.getGlobalCooldown())).maxLength(7).build(), DialogInputs.text((String)JSON_PLAYER_AMOUNT, (TextLocale)INPUT_PLAYER_AMOUNT).initial(String.valueOf(limits.getPlayerAmount())).maxLength(7).build(), DialogInputs.text((String)JSON_PLAYER_COOLDOWN, (TextLocale)INPUT_PLAYER_COOLDOWN).initial(String.valueOf(limits.getPlayerCooldown())).maxLength(7).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, limits.isEnabled());
                CooldownMode cooldownType = nbtHolder.getText(JSON_COOLDOWN_MODE).map(raw -> (CooldownMode)Enums.get((String)raw, CooldownMode.class)).orElse(limits.getCooldownType());
                int globalAmount = nbtHolder.getInt(JSON_GLOBAL_AMOUNT, limits.getGlobalAmount());
                long globalCooldown = nbtHolder.getInt(JSON_GLOBAL_COOLDOWN, (int)limits.getGlobalCooldown());
                int playerAmount = nbtHolder.getInt(JSON_PLAYER_AMOUNT, limits.getPlayerAmount());
                long playerCooldown = nbtHolder.getInt(JSON_PLAYER_COOLDOWN, (int)limits.getPlayerCooldown());
                limits.setEnabled(enabled);
                limits.setCooldownType(cooldownType);
                limits.setGlobalAmount(globalAmount);
                limits.setGlobalCooldown(globalCooldown);
                limits.setPlayerAmount(playerAmount);
                limits.setPlayerCooldown(playerCooldown);
                reward.getCrate().markDirty();
                viewer.callback();
            });
        });
    }
}

