/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.opening.OpeningProvider;
import su.nightexpress.excellentcrates.api.opening.ProviderLoader;
import su.nightexpress.excellentcrates.api.opening.ProviderSupplier;
import su.nightexpress.excellentcrates.opening.inventory.InventoryProvider;
import su.nightexpress.excellentcrates.opening.selectable.SelectableProvider;
import su.nightexpress.excellentcrates.opening.world.provider.SimpleRollProvider;

public class ProviderRegistry {
    private static final Map<String, ProviderLoader> LOADERS = new HashMap<String, ProviderLoader>();
    private static final Set<OpeningProvider> PROVIDERS = new HashSet<OpeningProvider>();

    public static void load() {
        ProviderRegistry.registerLoader("/openings/inventory/", InventoryProvider::new);
        ProviderRegistry.registerLoader("/openings/simple_roll/", SimpleRollProvider::new);
        ProviderRegistry.registerLoader("/openings/selectable/", SelectableProvider::new);
    }

    public static void clear() {
        LOADERS.clear();
        PROVIDERS.clear();
    }

    public static void registerLoader(@NotNull String directory, @NotNull ProviderSupplier supplier) {
        LOADERS.put(directory.toLowerCase(), new ProviderLoader(directory, supplier));
    }

    public static void registerProvider(@NotNull OpeningProvider provider) {
        PROVIDERS.add(provider);
    }

    @NotNull
    public static Set<ProviderLoader> getLoaders() {
        return new HashSet<ProviderLoader>(LOADERS.values());
    }

    @NotNull
    public static Set<OpeningProvider> getProviders() {
        return new HashSet<OpeningProvider>(PROVIDERS);
    }
}

