/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.inventory.spinner.provider;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.opening.inventory.InventoryOpening;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerData;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerProvider;
import su.nightexpress.excellentcrates.opening.inventory.spinner.impl.RewardSpinner;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.Lists;

public class RewardProvider
implements SpinnerProvider,
Writeable {
    private final Set<String> rarities;

    public RewardProvider(@NotNull Set<String> rarities) {
        this.rarities = new HashSet<String>(rarities);
    }

    @NotNull
    public static RewardProvider everything() {
        return new RewardProvider(Lists.newSet((Object[])new String[]{"*"}));
    }

    @NotNull
    public static RewardProvider read(@NotNull FileConfig config, @NotNull String path) {
        Set rarities = (Set)ConfigValue.create((String)(path + ".Rarities"), Set.of("*"), (String[])new String[0]).read(config);
        return new RewardProvider(rarities);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Rarities", this.rarities);
    }

    @Override
    @NotNull
    public RewardSpinner createSpinner(@NotNull CratesPlugin plugin, @NotNull SpinnerData data, @NotNull InventoryOpening opening) {
        HashSet<Rarity> rarities = new HashSet<Rarity>();
        if (this.rarities.contains("*")) {
            rarities.addAll(plugin.getCrateManager().getRarities());
        } else {
            rarities.addAll(this.rarities.stream().map(rId -> plugin.getCrateManager().getRarity((String)rId)).filter(Objects::nonNull).toList());
        }
        return new RewardSpinner(data, opening, rarities);
    }

    @NotNull
    public Set<String> getRarities() {
        return this.rarities;
    }
}

