/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.util.text.NightMessage;

public class CrateLogger {
    private final CratesPlugin plugin;
    private final DateTimeFormatter formatter;

    public CrateLogger(@NotNull CratesPlugin plugin) {
        this.plugin = plugin;
        this.formatter = DateTimeFormatter.ofPattern((String)Config.LOGS_DATE_FORMAT.get());
    }

    public void logReward(@NotNull Player player, @NotNull Reward reward) {
        Crate crate = reward.getCrate();
        String text = player.getName() + " won " + reward.getName() + " (ID: " + reward.getId() + ", Weight: " + reward.getWeight() + ") from " + crate.getName() + " (ID: " + crate.getId() + ")";
        this.log(text);
    }

    private void log(@NotNull String text) {
        if (!((Boolean)Config.LOGS_TO_CONSOLE.get()).booleanValue() && !((Boolean)Config.LOGS_TO_FILE.get()).booleanValue()) {
            return;
        }
        text = NightMessage.stripTags((String)text);
        if (((Boolean)Config.LOGS_TO_CONSOLE.get()).booleanValue()) {
            this.plugin.info(text);
        }
        if (((Boolean)Config.LOGS_TO_FILE.get()).booleanValue()) {
            String date = LocalDateTime.now().format(this.formatter);
            String path = String.valueOf(this.plugin.getDataFolder()) + "/openings.log";
            try {
                BufferedWriter output = new BufferedWriter(new FileWriter(path, true));
                output.append("[").append(date).append("] ").append(text);
                output.newLine();
                output.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }
}

