/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.reward.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.RewardType;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.crate.reward.AbstractReward;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.ItemNbt;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.problem.ProblemReporter;

public class ItemReward
extends AbstractReward {
    private boolean customPreview;
    private boolean allowItemPlaceholders;
    private List<AdaptedItem> items = new ArrayList<AdaptedItem>();

    public ItemReward(@NotNull CratesPlugin plugin, @NotNull Crate crate, @NotNull String id, @NotNull Rarity rarity) {
        super(plugin, crate, id, rarity);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config, @NotNull String path) {
        if (config.contains(path + ".Items")) {
            int count = 0;
            for (String encoded : config.getStringList(path + ".Items")) {
                ItemStack itemStack = ItemNbt.decompress((String)encoded);
                if (itemStack == null) {
                    return;
                }
                AdaptedItem provider = ItemHelper.vanilla(itemStack);
                config.set(path + ".ItemsData." + count++, (Object)provider);
            }
            config.remove(path + ".Items");
        }
        this.setCustomPreview((Boolean)ConfigValue.create((String)(path + ".Custom_Preview"), (boolean)false, (String[])new String[0]).read(config));
        this.setAllowItemPlaceholders(config.getBoolean(path + ".Placeholder_Apply"));
        config.getSection(path + ".ItemsData").forEach(sId -> {
            AdaptedItem item = ItemHelper.read(config, path + ".ItemsData." + sId).orElse(null);
            if (item == null) {
                this.plugin.error("Invalid/Unknown item data at '" + String.valueOf(config.getPath()) + "' -> '" + path + ".ItemsData." + sId + "'.");
                return;
            }
            this.items.add(item);
        });
    }

    @Override
    protected void writeAdditional(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Custom_Preview", (Object)this.customPreview);
        config.set(path + ".Placeholder_Apply", (Object)this.allowItemPlaceholders);
        config.remove(path + ".ItemsData");
        int count = 0;
        for (AdaptedItem provider : this.items) {
            config.set(path + ".ItemsData." + count++, (Object)provider);
        }
    }

    @Override
    protected void collectAdditionalProblems(@NotNull ProblemReporter reporter) {
        if (!this.hasContent()) {
            reporter.report(Lang.INSPECTIONS_REWARD_NO_ITEMS.text());
        } else if (this.hasInvalidItems()) {
            reporter.report(Lang.INSPECTIONS_REWARD_ITEMS.get(false));
        }
        if (this.customPreview && !this.preview.isValid()) {
            reporter.report(Lang.INSPECTIONS_REWARD_PREVIEW.get(false));
        }
    }

    @Override
    @NotNull
    public RewardType getType() {
        return RewardType.ITEM;
    }

    @Override
    public boolean hasContent() {
        return !this.items.isEmpty();
    }

    public boolean hasInvalidItems() {
        return this.items.stream().anyMatch(Predicate.not(AdaptedItem::isValid));
    }

    public int countItems() {
        return this.items.size();
    }

    @Override
    public void giveContent(@NotNull Player player) {
        Replacer replacer = this.createContentReplacer(player);
        this.getItems().forEach(provider -> {
            ItemStack itemStack = provider.getItemStack();
            if (itemStack == null) {
                return;
            }
            if (this.allowItemPlaceholders) {
                ItemUtil.editMeta((ItemStack)itemStack, meta -> {
                    if (meta.hasItemName()) {
                        meta.setItemName(replacer.apply(String.valueOf(ItemUtil.getItemNameSerialized((ItemMeta)meta))));
                    }
                    if (meta.hasDisplayName()) {
                        meta.setDisplayName(replacer.apply(String.valueOf(ItemUtil.getCustomNameSerialized((ItemMeta)meta))));
                    }
                    if (meta.hasLore()) {
                        meta.setLore(replacer.apply(ItemUtil.getLoreSerialized((ItemMeta)meta)));
                    }
                });
            }
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack});
        });
    }

    public boolean isCustomPreview() {
        return this.customPreview;
    }

    public void setCustomPreview(boolean customPreview) {
        this.customPreview = customPreview;
    }

    public void setAllowItemPlaceholders(boolean allowItemPlaceholders) {
        this.allowItemPlaceholders = allowItemPlaceholders;
    }

    public boolean isAllowItemPlaceholders() {
        return this.allowItemPlaceholders;
    }

    @Override
    @NotNull
    public String getName() {
        return ItemUtil.getNameSerialized((ItemStack)this.getPreviewItem());
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return ItemUtil.getLoreSerialized((ItemStack)this.getPreviewItem());
    }

    @Override
    @NotNull
    public ItemStack getPreviewItem() {
        return ItemHelper.toItemStack(this.getPreview());
    }

    @Override
    @NotNull
    public AdaptedItem getPreview() {
        if (this.customPreview || this.items.isEmpty()) {
            return super.getPreview();
        }
        return this.items.getFirst();
    }

    @NotNull
    public List<AdaptedItem> getItems() {
        return this.items;
    }

    public void setItems(@NotNull List<AdaptedItem> items) {
        this.items = new ArrayList<AdaptedItem>(items.stream().filter(AdaptedItem::isValid).limit(27L).toList());
    }

    public void addItem(@NotNull AdaptedItem provider) {
        if (this.items.size() >= 27) {
            return;
        }
        if (!provider.isValid()) {
            return;
        }
        this.items.add(provider);
    }
}

