/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.crate;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CratePreviewDialog
extends CrateDialog<Crate> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Crate.Preview.Title").text(CratePreviewDialog.title("Crate", "Preview Template"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Crate.Preview.Body").dialogElement(400, new String[]{"Select a preview GUI template for the crate.", "You can create and edit previews in the " + TagWrappers.SOFT_YELLOW.wrap("/previews/") + " directory.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192 ") + "To disable crate preview, uncheck the " + TagWrappers.SOFT_YELLOW.wrap("Enabled") + " box."});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Dialog.Crate.Preview.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_PREVIEW = LangEntry.builder((String)"Dialog.Crate.Preview.Input.Preview").text(TagWrappers.SOFT_YELLOW.wrap("Preview"));
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_ID = "id";
    private final CratesPlugin plugin;

    public CratePreviewDialog(@NotNull CratesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        ArrayList entries = new ArrayList();
        this.plugin.getCrateManager().getPreviewNames().stream().sorted(String::compareTo).forEach(id -> entries.add(new WrappedSingleOptionEntry(id, FileConfig.withExtension((String)id), crate.getPreviewId().equalsIgnoreCase((String)id))));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(crate.isPreviewEnabled()).build(), DialogInputs.singleOption((String)JSON_ID, (TextLocale)INPUT_PREVIEW, (List)entries).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, false);
                String id = nbtHolder.getText(JSON_ID, crate.getPreviewId());
                crate.setPreviewEnabled(enabled);
                crate.setPreviewId(id);
                crate.markDirty();
                viewer.callback();
            });
        });
    }
}

