/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.impl.CommandReward;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedBooleanDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardPreviewDialog
extends CrateDialog<Data> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Reward.Preview.Title").text(RewardPreviewDialog.title("Reward", "Preview"));
    private static final TextLocale INPUT_NBT = LangEntry.builder((String)"Dialog.Reward.Preview.Input.NBT").text(TagWrappers.SOFT_RED.wrap("Save as NBT"));
    private static final TextLocale INPUT_REP_NAME = LangEntry.builder((String)"Dialog.Reward.Preview.Input.ReplaceName").text("Replace Reward Name");
    private static final TextLocale INPUT_REP_DESC = LangEntry.builder((String)"Dialog.Reward.Preview.Input.ReplaceDesc").text("Replace Reward Description");
    private static final DialogElementLocale BODY_NORMAL = LangEntry.builder((String)"Dialog.Reward.Preview.Body.Normal").dialogElement(400, new String[]{"Please confirm reward preview replacement.", TagWrappers.GRAY.wrap("Check the additional fields if needed.")});
    private static final DialogElementLocale BODY_CUSTOM = LangEntry.builder((String)"Dialog.Reward.Preview.Body.Custom").dialogElement(400, new String[]{"Please confirm reward preview replacement.", TagWrappers.GRAY.wrap("Check the additional fields if needed."), "", TagWrappers.SOFT_RED.and((TagWrapper)TagWrappers.BOLD).wrap("IMPORTANT NOTE:"), "If the item above doesn't match the one you used, enable the " + TagWrappers.SOFT_RED.wrap("Save as NBT") + " option.", TagWrappers.GRAY.wrap("This ensures the exact item data is saved correctly.")});
    private static final String JSON_USE_NBT = "use_nbt";
    private static final String JSON_REPLACE_NAME = "replace_name";
    private static final String JSON_REPLACE_DESCRIPTION = "replace_description";

    public void show(@NotNull Player player, @NotNull Reward reward, @NotNull ItemStack itemStack, @Nullable Runnable callback) {
        this.show(player, new Data(reward, itemStack), callback);
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Data data) {
        Reward reward = data.reward;
        Crate crate = reward.getCrate();
        ItemStack itemStack = data.itemStack;
        ItemMeta meta = itemStack.getItemMeta();
        AdaptedItem adaptedItem = ItemHelper.adapt(itemStack);
        boolean isCustom = !adaptedItem.getAdapter().isVanilla();
        ArrayList<WrappedBooleanDialogInput> inputs = new ArrayList<WrappedBooleanDialogInput>();
        if (reward instanceof CommandReward && meta != null) {
            if (meta.hasDisplayName() || meta.hasItemName()) {
                inputs.add(DialogInputs.bool((String)JSON_REPLACE_NAME, (TextLocale)INPUT_REP_NAME).build());
            }
            if (meta.hasLore()) {
                inputs.add(DialogInputs.bool((String)JSON_REPLACE_DESCRIPTION, (TextLocale)INPUT_REP_DESC).build());
            }
        }
        if (isCustom) {
            inputs.add(DialogInputs.bool((String)JSON_USE_NBT, (TextLocale)INPUT_NBT).initial(false).build());
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.item((ItemStack)(isCustom ? ItemHelper.toItemStack(adaptedItem) : itemStack)).build(), DialogBodies.plainMessage((DialogElementLocale)(isCustom ? BODY_CUSTOM : BODY_NORMAL))}).inputs(inputs).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean allowCustoms = !nbtHolder.getBoolean(JSON_USE_NBT, false);
                AdaptedItem adapt = ItemHelper.adapt(itemStack, allowCustoms);
                if (reward instanceof CommandReward) {
                    CommandReward commandReward = (CommandReward)reward;
                    boolean replaceName = nbtHolder.getBoolean(JSON_REPLACE_NAME).orElse(false);
                    boolean replaceDesc = nbtHolder.getBoolean(JSON_REPLACE_DESCRIPTION).orElse(false);
                    if (replaceName && meta != null) {
                        commandReward.setName(String.valueOf(ItemUtil.getNameSerialized((ItemMeta)meta)));
                    }
                    if (replaceDesc && meta != null) {
                        commandReward.setDescription(ItemUtil.getLoreSerialized((ItemMeta)meta));
                    }
                }
                reward.setPreview(adapt);
                crate.markDirty();
                viewer.callback();
            });
        });
    }

    public record Data(@NotNull Reward reward, @NotNull ItemStack itemStack) {
    }
}

