/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.registry;

import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.cost.CostType;
import su.nightexpress.excellentcrates.crate.cost.type.impl.EcoCostType;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.BeaconEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.DummyEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.HeartEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.HelixEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.PulsarEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.SimpleEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.SphereEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.SpiralEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.TornadoEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.VortexEffect;
import su.nightexpress.nightcore.bridge.registry.NightRegistry;

public class CratesRegistries {
    public static final NightRegistry<String, CrateEffect> EFFECT = new NightRegistry();
    public static final NightRegistry<String, CostType> COST_TYPE = new NightRegistry();

    public static void load(@NotNull CratesPlugin plugin) {
        CratesRegistries.registerDefaultEffects();
        CratesRegistries.registerCostType(new EcoCostType(plugin));
    }

    private static void registerDefaultEffects() {
        CratesRegistries.registerEffect(new BeaconEffect());
        CratesRegistries.registerEffect(new HeartEffect());
        CratesRegistries.registerEffect(new HelixEffect());
        CratesRegistries.registerEffect(new PulsarEffect());
        CratesRegistries.registerEffect(new SimpleEffect());
        CratesRegistries.registerEffect(new SphereEffect());
        CratesRegistries.registerEffect(new SpiralEffect());
        CratesRegistries.registerEffect(new TornadoEffect());
        CratesRegistries.registerEffect(new VortexEffect());
    }

    public static void clear() {
        COST_TYPE.clear();
        EFFECT.clear();
    }

    public static void registerEffect(@NotNull CrateEffect effect) {
        EFFECT.register((Object)effect.getId(), (Object)effect);
    }

    public static void registerCostType(@NotNull CostType type) {
        COST_TYPE.register((Object)type.getId(), (Object)type);
    }

    @NotNull
    public static CrateEffect effectOrDummy(@NotNull String id) {
        return EFFECT.lookup((Object)id).orElse(DummyEffect.INSTANCE);
    }

    @NotNull
    public static Set<CrateEffect> getEffects() {
        return EFFECT.values();
    }

    @Nullable
    public static CostType getCostType(@NotNull String id) {
        return (CostType)COST_TYPE.byKey((Object)id);
    }

    @NotNull
    public static Set<CostType> getAvailableCostTypes() {
        return COST_TYPE.map().values().stream().filter(CostType::isAvailable).collect(Collectors.toSet());
    }
}

