/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.effect.impl;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class TornadoEffect
extends CrateEffect {
    private static final double Y_OFFSET = 0.15;
    private static final float TORNADO_HEIGHT = 3.15f;
    private static final float MAX_TORNADO_RADIUS = 2.25f;
    private static final double DISTANCE = 0.375;

    public TornadoEffect() {
        super(2L, 8);
    }

    @Override
    public void onStepPlay(@NotNull Location origin, @NotNull UniParticle particle, int step, @NotNull Player player) {
        Location loc = origin.clone().add(0.0, 0.5, 0.0);
        double offset = 0.4196428444380126;
        double vertical = (double)3.15f - 0.375 * (double)step;
        double radius = offset * vertical;
        if (radius > 2.25) {
            radius = 2.25;
        }
        for (Vector vector : this.createCircle(vertical, radius)) {
            Location location = loc.add(vector);
            particle.play(player, location, (double)0.1f, 0.0, 3);
            loc.subtract(vector);
        }
        loc.subtract(0.0, 0.15, 0.0);
    }

    private List<Vector> createCircle(double vertical, double radius) {
        double amount = radius * 64.0;
        double d2 = Math.PI * 2 / amount;
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        int i = 0;
        while ((double)i < amount) {
            double d3 = (double)i * d2;
            double cos = radius * Math.cos(d3);
            double sin = radius * Math.sin(d3);
            Vector vector = new Vector(cos, vertical, sin);
            vectors.add(vector);
            ++i;
        }
        return vectors;
    }
}

