/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.ArrayList;
import java.util.stream.IntStream;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.EditorLang;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class RewardListMenu
extends LinkedMenu<CratesPlugin, Crate>
implements Filled<Reward> {
    private static final String SKULL_SORT = "5cce7359a25de6da56308e6a369c6372e2c30906c62647040da137a32addc9";
    private static final String SKULL_CREATE = "e3c81adc6c06d95c65b6c1089755a04d7ebc414f51ba66d14d0c4c1d71520df6";

    public RewardListMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_REWARD_LIST.getString());
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openOptionsMenu(viewer.getPlayer(), (Crate)((Object)((Object)((Object)this.getLink(viewer))))))));
        this.addItem(MenuItem.buildNextPage((Menu)this, (int)44));
        this.addItem(MenuItem.buildPreviousPage((Menu)this, (int)36));
        this.addItem(ItemUtil.getSkinHead((String)SKULL_CREATE), EditorLang.REWARD_CREATE, 42, (viewer, event, crate) -> this.runNextTick(() -> plugin.getEditorManager().openRewardCreation(viewer.getPlayer(), (Crate)((Object)crate))));
        this.addItem(ItemUtil.getSkinHead((String)SKULL_SORT), EditorLang.REWARD_SORT, 38, (viewer, event, crate) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openRewardSort(viewer.getPlayer(), (Crate)((Object)crate))));
    }

    @NotNull
    public MenuFiller<Reward> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems(((Crate)((Object)this.getLink(viewer))).getRewards());
        autoFill.setItemCreator(reward -> NightItem.fromItemStack((ItemStack)reward.getPreviewItem()).setHideComponents(true).localized(EditorLang.REWARD_OBJECT).replacement(replacer -> replacer.replace(reward.replaceAllPlaceholders())));
        autoFill.setItemClick(reward -> (viewer1, event) -> {
            Crate crate = (Crate)((Object)((Object)((Object)this.getLink(viewer1))));
            if (event.isShiftClick()) {
                ArrayList<Reward> all = new ArrayList<Reward>(crate.getRewards());
                int index = all.indexOf(reward);
                int allSize = all.size();
                if (event.isLeftClick()) {
                    if (index + 1 >= allSize) {
                        return;
                    }
                    all.remove(index);
                    all.add(index + 1, (Reward)reward);
                } else if (event.isRightClick()) {
                    if (index == 0) {
                        return;
                    }
                    all.remove(index);
                    all.add(index - 1, (Reward)reward);
                }
                crate.setRewards(all);
                crate.saveRewards();
                this.runNextTick(() -> this.flush(viewer));
                return;
            }
            if (event.isLeftClick()) {
                this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openRewardOptions(viewer1.getPlayer(), (Reward)reward));
            }
        });
        return autoFill.build();
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }
}

