/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.hologram;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.hologram.HologramHandler;
import su.nightexpress.excellentcrates.hologram.entity.HologramData;
import su.nightexpress.excellentcrates.hologram.entity.HologramEntity;
import su.nightexpress.excellentcrates.hologram.listener.HologramListener;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.excellentcrates.util.pos.WorldPos;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class HologramManager
extends AbstractManager<CratesPlugin> {
    private final Map<String, HologramData> hologramDataMap = new HashMap<String, HologramData>();
    private final Set<String> hidden = new HashSet<String>();
    private final HologramHandler handler;
    private boolean useDisplays;
    private double lineGap;

    public HologramManager(@NotNull CratesPlugin plugin, @NotNull HologramHandler handler) {
        super((NightCorePlugin)plugin);
        this.handler = handler;
    }

    protected void onLoad() {
        this.useDisplays = (Boolean)Config.CRATE_HOLOGRAM_USE_DISPLAYS.get();
        this.lineGap = (Double)Config.CRATE_HOLOGRAM_LINE_GAP.get();
        this.addListener((SimpeListener)new HologramListener((CratesPlugin)this.plugin, this));
        this.addAsyncTask(this::tickHolograms, (Integer)Config.CRATE_HOLOGRAM_UPDATE_INTERVAL.get());
    }

    protected void onShutdown() {
        this.hologramDataMap.values().forEach(hologramData -> this.handler.destroyEntity(hologramData.getEntityIDs()));
        this.hologramDataMap.clear();
        this.hidden.clear();
    }

    public void tickHolograms() {
        ((CratesPlugin)this.plugin).getCrateManager().getCrates().forEach(crate -> {
            if (!crate.isHologramEnabled()) {
                return;
            }
            this.refresh((Crate)((Object)crate));
        });
    }

    public void handleQuit(@NotNull Player player) {
        this.hologramDataMap.values().forEach(hologramData -> hologramData.getEntities().forEach(holo -> holo.removePlayer(player)));
    }

    public void hide(@NotNull Crate crate) {
        if (this.hidden.add(crate.getId())) {
            this.remove(crate);
        }
    }

    public void show(@NotNull Crate crate) {
        if (this.hidden.remove(crate.getId())) {
            this.refresh(crate);
        }
    }

    public void refresh(@NotNull Crate crate) {
        this.createIfAbsent(crate);
        HologramData hologramData = this.hologramDataMap.get(crate.getId());
        if (hologramData == null || this.hidden.contains(crate.getId())) {
            return;
        }
        double yOffset = crate.getHologramYOffset();
        if (this.useDisplays) {
            yOffset += 0.2;
        }
        for (HologramEntity entity : hologramData.getEntities()) {
            WorldPos position = entity.position();
            if (!position.isChunkLoaded()) {
                return;
            }
            World world = position.getWorld();
            Block block = position.toBlock();
            if (world == null || block == null) {
                return;
            }
            double height = block.getBoundingBox().getHeight() / 2.0 + yOffset;
            Location location = LocationUtil.setCenter3D((Location)block.getLocation()).add(0.0, height + entity.gap(), 0.0);
            Players.getOnline().forEach(player -> {
                boolean create;
                if (!CrateUtils.isInEffectRange(player, location)) {
                    entity.removePlayer((Player)player);
                    this.handler.destroyEntity((Player)player, Lists.newSet((Object[])new Integer[]{entity.entityID()}));
                    return;
                }
                String text = Replacer.create().replace(crate.replacePlaceholders()).replacePlaceholderAPI(player).apply(entity.text());
                boolean bl = create = !entity.isCreated((Player)player);
                if (create) {
                    entity.addPlayer((Player)player);
                }
                this.sendHologramPackets((Player)player, entity.entityID(), create, location, text);
            });
        }
    }

    private void createIfAbsent(@NotNull Crate crate) {
        if (this.hologramDataMap.containsKey(crate.getId())) {
            return;
        }
        List<String> originText = crate.getHologramText();
        if (originText.isEmpty()) {
            return;
        }
        HologramData hologramData = this.hologramDataMap.computeIfAbsent(crate.getId(), k -> new HologramData());
        Collections.reverse(originText);
        crate.getBlockPositions().forEach(pos -> {
            double currentGap = 0.0;
            for (String text : originText) {
                int entityID = EntityUtil.nextEntityId();
                hologramData.getEntities().add(new HologramEntity(entityID, (WorldPos)pos, text, currentGap, (Set<UUID>)new HashSet<UUID>()));
                currentGap += this.lineGap;
            }
        });
    }

    public void create(@NotNull Crate crate) {
        this.createIfAbsent(crate);
    }

    public void remove(@NotNull Crate crate) {
        HologramData hologramData = this.hologramDataMap.remove(crate.getId());
        if (hologramData == null) {
            return;
        }
        this.handler.destroyEntity(hologramData.getEntityIDs());
    }

    private void sendHologramPackets(@NotNull Player player, int entityID, boolean create, @NotNull Location location, @NotNull String textLine) {
        EntityType type = this.useDisplays ? EntityType.TEXT_DISPLAY : EntityType.ARMOR_STAND;
        this.handler.displayHolograms(player, entityID, create, type, location, textLine);
    }
}

