/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.hologram.handler;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.hologram.HologramHandler;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.text.NightMessage;

public class HologramPacketsHandler
implements HologramHandler {
    private final PlayerManager playerManager = PacketEvents.getAPI().getPlayerManager();

    private void sendPacket(@NotNull Player player, @NotNull PacketWrapper<?> packet) {
        this.playerManager.sendPacket((Object)player, packet);
    }

    private void broadcastPacket(@NotNull PacketWrapper<?> packet) {
        Players.getOnline().forEach(player -> this.playerManager.sendPacket(player, packet));
    }

    @Override
    public void displayHolograms(@NotNull Player player, int entityID, boolean create, @NotNull org.bukkit.entity.EntityType type, @NotNull org.bukkit.Location location, @NotNull String textLine) {
        WrapperPlayServerSpawnEntity spawnPacket = this.createSpawnPacket(type, location, entityID);
        WrapperPlayServerEntityMetadata dataPacket = this.createMetadataPacket(entityID, dataList -> {
            if (type == org.bukkit.entity.EntityType.ARMOR_STAND) {
                dataList.add(new EntityData(0, EntityDataTypes.BYTE, (Object)32));
                dataList.add(new EntityData(2, EntityDataTypes.OPTIONAL_COMPONENT, Optional.of(NightMessage.asJson((String)textLine))));
                dataList.add(new EntityData(3, EntityDataTypes.BOOLEAN, (Object)true));
                dataList.add(new EntityData(5, EntityDataTypes.BOOLEAN, (Object)true));
                dataList.add(new EntityData(15, EntityDataTypes.BYTE, (Object)25));
            } else {
                dataList.add(new EntityData(15, EntityDataTypes.BYTE, (Object)1));
                dataList.add(new EntityData(23, EntityDataTypes.COMPONENT, (Object)NightMessage.asJson((String)textLine)));
                dataList.add(new EntityData(24, EntityDataTypes.INT, (Object)Integer.MAX_VALUE));
                dataList.add(new EntityData(27, EntityDataTypes.BYTE, (Object)1));
            }
        });
        if (create) {
            this.sendPacket(player, (PacketWrapper<?>)spawnPacket);
        }
        this.sendPacket(player, (PacketWrapper<?>)dataPacket);
    }

    @Override
    public void destroyEntity(@NotNull Set<Integer> idList) {
        this.broadcastPacket((PacketWrapper<?>)this.createDestroyPacket(idList));
    }

    @Override
    public void destroyEntity(@NotNull Player player, @NotNull Set<Integer> idList) {
        this.sendPacket(player, (PacketWrapper<?>)this.createDestroyPacket(idList));
    }

    @NotNull
    private WrapperPlayServerDestroyEntities createDestroyPacket(@NotNull Set<Integer> list) {
        return new WrapperPlayServerDestroyEntities(list.stream().mapToInt(i -> i).toArray());
    }

    @NotNull
    private WrapperPlayServerSpawnEntity createSpawnPacket(@NotNull org.bukkit.entity.EntityType entityType, @NotNull org.bukkit.Location location, int entityID) {
        EntityType type = SpigotConversionUtil.fromBukkitEntityType((org.bukkit.entity.EntityType)entityType);
        Location loc = SpigotConversionUtil.fromBukkitLocation((org.bukkit.Location)location);
        return new WrapperPlayServerSpawnEntity(entityID, UUID.randomUUID(), type, loc, 0.0f, 0, null);
    }

    @NotNull
    private WrapperPlayServerEntityMetadata createMetadataPacket(int entityID, @NotNull Consumer<List<EntityData>> consumer) {
        ArrayList dataList = new ArrayList();
        consumer.accept(dataList);
        return new WrapperPlayServerEntityMetadata(entityID, dataList);
    }
}

