/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.item;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesAPI;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.api.item.ItemType;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.item.provider.AbstractItemProvider;
import su.nightexpress.excellentcrates.item.provider.impl.CustomItemProvider;
import su.nightexpress.excellentcrates.item.provider.impl.DummyItemProvider;
import su.nightexpress.excellentcrates.item.provider.impl.VanillaItemProvider;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.PDCUtil;

public class ItemTypes {
    public static final DummyItemProvider DUMMY = new DummyItemProvider();

    public static boolean isDummy(@NotNull ItemStack itemStack) {
        return PDCUtil.getBoolean((ItemStack)itemStack, (NamespacedKey)Keys.dummyItem).isPresent();
    }

    @NotNull
    public static ItemProvider read(@NotNull FileConfig config, @NotNull String path) {
        ItemType type = (ItemType)config.getEnum(path + ".Type", ItemType.class, (Enum)ItemType.VANILLA);
        if (type == ItemType.CUSTOM && !CrateUtils.hasEconomyBridge()) {
            CratesAPI.error("Could not load custom item due to missing EconomyBridge dependency. Caused by '" + config.getFile().getName() + "' -> '" + path + "'.");
            return DUMMY;
        }
        AbstractItemProvider provider = switch (type) {
            default -> throw new MatchException(null, null);
            case ItemType.VANILLA -> VanillaItemProvider.read(config, path);
            case ItemType.CUSTOM -> CustomItemProvider.read(config, path);
        };
        return provider == null ? DUMMY : provider;
    }

    @NotNull
    public static ItemProvider vanilla(@NotNull ItemStack itemStack) {
        return VanillaItemProvider.fromItem(itemStack);
    }

    @NotNull
    public static ItemProvider fromItem(@NotNull ItemStack itemStack) {
        ItemProvider provider = null;
        if (CrateUtils.hasEconomyBridge()) {
            provider = CustomItemProvider.fromItem(itemStack);
        }
        if (provider == null) {
            provider = ItemTypes.vanilla(itemStack);
        }
        return provider;
    }
}

