/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.key;

import java.io.File;
import java.util.function.UnaryOperator;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.NightMessage;

public class CrateKey
extends AbstractFileData<CratesPlugin> {
    private String name;
    private boolean virtual;
    private ItemProvider provider;
    private boolean itemStackable;

    public CrateKey(@NotNull CratesPlugin plugin, @NotNull File file) {
        super((NightCorePlugin)plugin, file);
    }

    protected boolean onLoad(@NotNull FileConfig config) {
        this.setName(config.getString("Name", this.getId()));
        this.setVirtual(config.getBoolean("Virtual"));
        if (config.contains("Item")) {
            NightItem item = config.getCosmeticItem("Item");
            ItemProvider provider = ItemTypes.vanilla(item.getItemStack());
            config.remove("Item");
            config.set("ItemData", (Object)provider);
        }
        this.setProvider(ItemTypes.read(config, "ItemData"));
        this.setItemStackable(config.getBoolean("ItemStackable", true));
        return true;
    }

    protected void onSave(@NotNull FileConfig config) {
        config.set("Name", (Object)this.name);
        config.set("Virtual", (Object)this.virtual);
        config.set("ItemData", (Object)this.provider);
        config.set("ItemStackable", (Object)this.itemStackable);
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return Placeholders.KEY.replacer((Object)this);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getNameTranslated() {
        return NightMessage.asLegacy((String)this.name);
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    @NotNull
    public ItemStack getRawItem() {
        ItemStack itemStack = this.provider.getItemStack();
        ItemUtil.editMeta((ItemStack)itemStack, meta -> meta.setDisplayName(this.getNameTranslated()));
        return itemStack;
    }

    @NotNull
    public ItemStack getItem() {
        ItemStack item = this.getRawItem();
        ItemUtil.editMeta((ItemStack)item, meta -> {
            if (!this.isItemStackable()) {
                meta.setMaxStackSize(Integer.valueOf(1));
            }
            PDCUtil.set((PersistentDataHolder)meta, (NamespacedKey)Keys.keyId, (String)this.getId());
        });
        return item;
    }

    public boolean isItemStackable() {
        return this.itemStackable;
    }

    public void setItemStackable(boolean itemStackable) {
        this.itemStackable = itemStackable;
    }

    @NotNull
    public ItemProvider getProvider() {
        return this.provider;
    }

    public void setProvider(@NotNull ItemProvider provider) {
        this.provider = provider;
    }
}

