/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.opening.inventory.InvOpeningProvider;
import su.nightexpress.excellentcrates.opening.inventory.InvOpeningType;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinMode;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerData;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerType;
import su.nightexpress.excellentcrates.opening.inventory.spinner.provider.AnimationProvider;
import su.nightexpress.excellentcrates.opening.inventory.spinner.provider.RewardProvider;
import su.nightexpress.excellentcrates.opening.world.provider.SimpleRollProvider;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.random.Rnd;
import su.nightexpress.nightcore.util.random.WeightedItem;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class OpeningUtils {
    private static final String TITLE = Tags.BLACK.enclose("Opening %crate_name%...");
    private static final int TICKS_TO_SKIP = 40;
    private static final int COMPLETION_PAUSE_TICKS = 40;
    private static final String SOUND = BukkitThing.toString((Keyed)Sound.BLOCK_NOTE_BLOCK_XYLOPHONE);
    private static final Set<String> RARITIES = Lists.newSet((Object[])new String[]{"*"});

    @Nullable
    public static Firework createFirework(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Firework firework = (Firework)world.spawn(location, Firework.class);
        FireworkMeta meta = firework.getFireworkMeta();
        FireworkEffect.Type type = (FireworkEffect.Type)Rnd.get((Object[])FireworkEffect.Type.values());
        Color color = Color.fromBGR((int)Rnd.get((int)256), (int)Rnd.get((int)256), (int)Rnd.get((int)256));
        Color fade = Color.fromBGR((int)Rnd.get((int)256), (int)Rnd.get((int)256), (int)Rnd.get((int)256));
        FireworkEffect effect = FireworkEffect.builder().flicker(Rnd.nextBoolean()).withColor(color).withFade(fade).with(type).trail(Rnd.nextBoolean()).build();
        meta.addEffect(effect);
        meta.setPower(Rnd.get((int)4));
        firework.setFireworkMeta(meta);
        return firework;
    }

    public static void setupSimpleRoll(@NotNull SimpleRollProvider provider) {
        provider.setStepsAmount(15);
        provider.setStepsTick(3L);
        provider.setCompletePause(40L);
    }

    public static void setupCSGO(@NotNull InvOpeningProvider config) {
        config.setInvType((MenuType)MenuType.GENERIC_9X3);
        config.setInvTitle(TITLE);
        config.setMode(InvOpeningType.NORMAL);
        config.setMaxTicksForSkip(40L);
        config.setCompletionPauseTicks(40L);
        config.setWinSlots(new int[]{13});
        Map animationDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap());
        Map rewardDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap());
        String rainbowId = "rainbow";
        animationDataMap.put("background", new SpinnerData(rainbowId, SpinMode.INDEPENDENT, "0,1,2,3,5,6,7,8,18,19,20,21,23,24,25,26", 71, 1, 0, 10, 1, null));
        rewardDataMap.put("main", new SpinnerData("default", SpinMode.SEQUENTAL, "17,16,15,14,13,12,11,10,9", 51, 1, 0, 5, 1, SOUND));
        config.getDefaultItems().put("arrow_up", NightItem.asCustomHead((String)"77334cddfab45d75ad28e1a47bf8cf5017d2f0982f6737da22d4972952510661").setDisplayName(Tags.CYAN.enclose(Tags.BOLD.enclose("\u2191 Your Reward \u2191"))).toMenuItem().setSlots(new int[]{22}).build());
        config.getDefaultItems().put("arrow_down", NightItem.asCustomHead((String)"e7742034f59db890c8004156b727c77ca695c4399d8e0da5ce9227cf836bb8e2").setDisplayName(Tags.CYAN.enclose(Tags.BOLD.enclose("\u2193 Your Reward \u2193"))).toMenuItem().setSlots(new int[]{4}).build());
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap()).put("default", new RewardProvider(RARITIES));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(rainbowId, new AnimationProvider(OpeningUtils.getRainbowPanes()));
    }

    public static void setupMystery(@NotNull InvOpeningProvider config) {
        config.setInvType((MenuType)MenuType.GENERIC_9X3);
        config.setInvTitle(TITLE);
        config.setMode(InvOpeningType.NORMAL);
        config.setMaxTicksForSkip(40L);
        config.setCompletionPauseTicks(40L);
        config.setWinSlots(new int[]{13});
        String rainbowId = "rainbow";
        Map animationDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap());
        Map rewardDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap());
        animationDataMap.put("background", new SpinnerData(rainbowId, SpinMode.INDEPENDENT, "0,1,2,3,4,5,6,7,8,9,10,11,12,14,15,16,17,18,19,20,21,22,23,24,25,26", 126, 1, 0, 30, 1, null));
        rewardDataMap.put("main", new SpinnerData("default", SpinMode.SEQUENTAL, "13", 51, 1, 0, 5, 1, SOUND));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap()).put("default", new RewardProvider(RARITIES));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(rainbowId, new AnimationProvider(OpeningUtils.getRainbowPanes()));
    }

    public static void setupRoulette(@NotNull InvOpeningProvider config) {
        config.setInvType((MenuType)MenuType.GENERIC_9X5);
        config.setInvTitle(TITLE);
        config.setMode(InvOpeningType.NORMAL);
        config.setMaxTicksForSkip(40L);
        config.setCompletionPauseTicks(40L);
        config.setWinSlots(new int[]{20});
        config.getDefaultItems().put("background", NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).toMenuItem().setSlots(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 24, 25, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 12, 13, 14, 22, 23, 30, 31, 32}).build());
        config.getDefaultItems().put("arrow_right", NightItem.asCustomHead((String)"a6af217aeddf0f40064969ebb2042f7aeafbc7d0f175a27624133a3befd10281").setDisplayName(Tags.LIGHT_RED.enclose(Tags.BOLD.enclose("YOUR PRIZE \u2192"))).toMenuItem().setSlots(new int[]{19}).build());
        config.getDefaultItems().put("arrow_left", NightItem.asCustomHead((String)"1c5a8aa8a4c03600a2b5a4eb6beb51d590260b095ee1cdaa976b09bdfe5661c6").setDisplayName(Tags.LIGHT_RED.enclose(Tags.BOLD.enclose("\u2190 YOUR PRIZE"))).toMenuItem().setSlots(new int[]{21}).build());
        Map rewardDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap());
        rewardDataMap.put("main", new SpinnerData("default", SpinMode.SEQUENTAL, "39,40,41,33,24,15,5,4,3,11,20,29", 75, 1, 0, 10, 1, BukkitThing.toString((Keyed)Sound.BLOCK_NOTE_BLOCK_BANJO)));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap()).put("default", new RewardProvider(RARITIES));
    }

    public static void setupChests(@NotNull InvOpeningProvider config) {
        config.setInvType((MenuType)MenuType.GENERIC_9X3);
        config.setInvTitle(TITLE);
        config.setMode(InvOpeningType.SELECTION);
        config.setMaxTicksForSkip(40L);
        config.setCompletionPauseTicks(40L);
        config.setWinSlots(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26});
        config.setSelectionAmount(3);
        config.setSelectionSlots(config.getWinSlots());
        config.setSelectionOriginIcon(NightItem.asCustomHead((String)"f98bc63f05f6378bf29ef10e3d82acb3ceb73a720bf80f30bc576d0ad8c40cfb").setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Click to select!"))).setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose("You can select and open " + Tags.LIGHT_YELLOW.enclose("3 chests") + ".")})));
        config.setSelectionClickedIcon(NightItem.asCustomHead((String)"6ed2d4a43d5556d676a53a53851a63ea19ab597668b18d0800fa0fbeacec58f3").setDisplayName(Tags.LIGHT_GREEN.enclose(Tags.BOLD.enclose("Selected Chest"))).setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose("Click to " + Tags.LIGHT_GREEN.enclose("deselect") + ".")})));
        String colorsId = "colors";
        HashMap<String, WeightedItem<NightItem>> backgroundItems = new HashMap<String, WeightedItem<NightItem>>();
        backgroundItems.put("white", OpeningUtils.getWeighted(Material.WHITE_STAINED_GLASS_PANE, 1.0));
        backgroundItems.put("lime", OpeningUtils.getWeighted(Material.LIME_STAINED_GLASS_PANE, 1.0));
        backgroundItems.put("green", OpeningUtils.getWeighted(Material.GREEN_STAINED_GLASS_PANE, 1.0));
        Map animationDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap());
        Map rewardDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap());
        animationDataMap.put("background", new SpinnerData(colorsId, SpinMode.INDEPENDENT, "%unselected_slots%", 67, 1, 0, 15, 1, null));
        rewardDataMap.put("main", new SpinnerData("default", SpinMode.INDEPENDENT, "%selected_slots%", 60, 1, 0, 15, 1, SOUND));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap()).put("default", new RewardProvider(RARITIES));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(colorsId, new AnimationProvider(backgroundItems));
    }

    public static void setupEnclosing(@NotNull InvOpeningProvider config) {
        config.setInvType((MenuType)MenuType.GENERIC_9X5);
        config.setInvTitle(TITLE);
        config.setMode(InvOpeningType.NORMAL);
        config.setMaxTicksForSkip(40L);
        config.setCompletionPauseTicks(40L);
        config.setWinSlots(new int[]{22});
        String fillBlackId = "fill_black";
        String fillGrayId = "fill_gray";
        String fillWhiteId = "fill_white";
        String pistonSound = BukkitThing.toString((Keyed)Sound.BLOCK_PISTON_EXTEND);
        Map animationDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap());
        Map rewardDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap());
        animationDataMap.put("black_1", new SpinnerData(fillBlackId, SpinMode.SYNCRHONIZED, "0,9,18,27,36,8,17,26,35,44", 1, 1, 13, 0, 0, pistonSound));
        animationDataMap.put("black_2", new SpinnerData(fillBlackId, SpinMode.SYNCRHONIZED, "1,10,19,28,37,7,16,25,34,43", 1, 1, 19, 0, 0, pistonSound));
        animationDataMap.put("gray_1", new SpinnerData(fillGrayId, SpinMode.SYNCRHONIZED, "2,11,20,29,38,6,15,24,33,42", 1, 1, 25, 0, 0, pistonSound));
        animationDataMap.put("gray_2", new SpinnerData(fillGrayId, SpinMode.SYNCRHONIZED, "3,5,39,41", 1, 1, 31, 0, 0, pistonSound));
        animationDataMap.put("gray_3", new SpinnerData(fillGrayId, SpinMode.SYNCRHONIZED, "4,40", 1, 1, 37, 0, 0, pistonSound));
        animationDataMap.put("white_1", new SpinnerData(fillWhiteId, SpinMode.SYNCRHONIZED, "12,21,30,14,23,32", 1, 1, 43, 0, 0, pistonSound));
        animationDataMap.put("white_2", new SpinnerData(fillWhiteId, SpinMode.SYNCRHONIZED, "13,31", 1, 1, 49, 0, 0, pistonSound));
        rewardDataMap.put("real", new SpinnerData("default", SpinMode.INDEPENDENT, "22", 25, 2, 0, 0, 0, BukkitThing.toString((Keyed)Sound.BLOCK_NOTE_BLOCK_XYLOPHONE)));
        rewardDataMap.put("dummy_1", new SpinnerData("default", SpinMode.INDEPENDENT, "0,9,18,27,36,8,17,26,35,44", 6, 2, 0, 0, 0, null));
        rewardDataMap.put("dummy_2", new SpinnerData("default", SpinMode.INDEPENDENT, "1,10,19,28,37,7,16,25,34,43", 9, 2, 0, 0, 0, null));
        rewardDataMap.put("dummy_3", new SpinnerData("default", SpinMode.INDEPENDENT, "2,11,20,29,38,6,15,24,33,42", 12, 2, 0, 0, 0, null));
        rewardDataMap.put("dummy_4", new SpinnerData("default", SpinMode.INDEPENDENT, "3,5,39,41", 15, 2, 0, 0, 0, null));
        rewardDataMap.put("dummy_5", new SpinnerData("default", SpinMode.INDEPENDENT, "4,40", 18, 2, 0, 0, 0, null));
        rewardDataMap.put("dummy_6", new SpinnerData("default", SpinMode.INDEPENDENT, "12,21,30,14,23,32", 21, 2, 0, 0, 0, null));
        rewardDataMap.put("dummy_7", new SpinnerData("default", SpinMode.INDEPENDENT, "13,31", 24, 2, 0, 0, 0, null));
        HashMap<String, WeightedItem<NightItem>> blackItems = new HashMap<String, WeightedItem<NightItem>>();
        blackItems.put("pane", OpeningUtils.getWeighted(Material.BLACK_STAINED_GLASS_PANE, 100.0));
        HashMap<String, WeightedItem<NightItem>> grayItems = new HashMap<String, WeightedItem<NightItem>>();
        grayItems.put("pane", OpeningUtils.getWeighted(Material.GRAY_STAINED_GLASS_PANE, 100.0));
        HashMap<String, WeightedItem<NightItem>> whiteItems = new HashMap<String, WeightedItem<NightItem>>();
        whiteItems.put("pane", OpeningUtils.getWeighted(Material.WHITE_STAINED_GLASS_PANE, 100.0));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap()).put("default", new RewardProvider(RARITIES));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(fillBlackId, new AnimationProvider(blackItems));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(fillGrayId, new AnimationProvider(grayItems));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(fillWhiteId, new AnimationProvider(whiteItems));
    }

    public static void setupStorm(@NotNull InvOpeningProvider config) {
        config.setInvType((MenuType)MenuType.GENERIC_9X6);
        config.setInvTitle(TITLE);
        config.setMode(InvOpeningType.NORMAL);
        config.setMaxTicksForSkip(40L);
        config.setCompletionPauseTicks(40L);
        config.setWinSlots(new int[]{49});
        String animCloud = "cloud";
        String animThunder = "thunder";
        String animClear = "clear";
        Map animationDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new LinkedHashMap());
        Map rewardDataMap = config.getSpinnerDataMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap());
        animationDataMap.put("cloud_1_down", new SpinnerData(animCloud, SpinMode.SEQUENTAL, "9,10,11,12,13", 5, 5, 9, 0, 0, null));
        animationDataMap.put("cloud_1_up", new SpinnerData(animCloud, SpinMode.SEQUENTAL, "1,2,3", 3, 5, 18, 0, 0, null));
        animationDataMap.put("cloud_2_up", new SpinnerData(animCloud, SpinMode.SEQUENTAL, "8,7,6,5", 4, 5, 9, 0, 0, null));
        animationDataMap.put("clouds_2_down", new SpinnerData(animCloud, SpinMode.SEQUENTAL, "17,16,15", 3, 5, 15, 0, 0, null));
        animationDataMap.put("cloud_2_down_clear_corner", new SpinnerData(animClear, SpinMode.SEQUENTAL, "17", 1, 1, 30, 0, 0, null));
        animationDataMap.put("rain_sound", new SpinnerData(animClear, SpinMode.INDEPENDENT, "-1", 1, 5, 30, 0, 0, BukkitThing.toString((Keyed)Sound.WEATHER_RAIN_ABOVE)));
        animationDataMap.put("thunder_1", new SpinnerData(animThunder, SpinMode.SEQUENTAL, "19,29,38,48", 4, 4, 52, 0, 0, null));
        animationDataMap.put("thunder_1_sound", new SpinnerData(animClear, SpinMode.INDEPENDENT, "-1", 1, 1, 66, 0, 0, BukkitThing.toString((Keyed)Sound.ENTITY_LIGHTNING_BOLT_IMPACT)));
        animationDataMap.put("thunder_1_clear", new SpinnerData(animClear, SpinMode.INDEPENDENT, "19,29,38,48", 1, 1, 71, 0, 0, null));
        animationDataMap.put("thunder_2", new SpinnerData(animThunder, SpinMode.SEQUENTAL, "24,33,41,50", 4, 4, 68, 0, 0, null));
        animationDataMap.put("thunder_2_sound", new SpinnerData(animClear, SpinMode.INDEPENDENT, "-1", 1, 1, 82, 0, 0, BukkitThing.toString((Keyed)Sound.ENTITY_LIGHTNING_BOLT_IMPACT)));
        animationDataMap.put("thunder_2_clear", new SpinnerData(animClear, SpinMode.INDEPENDENT, "24,33,41,50", 1, 1, 87, 0, 0, null));
        rewardDataMap.put("real", new SpinnerData("default", SpinMode.INDEPENDENT, "49", 1, 1, 83, 0, 0, BukkitThing.toString((Keyed)Sound.BLOCK_AMETHYST_BLOCK_RESONATE)));
        HashMap<String, WeightedItem<NightItem>> cloudItems = new HashMap<String, WeightedItem<NightItem>>();
        cloudItems.put("cloud", OpeningUtils.getWeighted(Material.WHITE_STAINED_GLASS_PANE, 100.0));
        HashMap<String, WeightedItem<NightItem>> thunderItems = new HashMap<String, WeightedItem<NightItem>>();
        thunderItems.put("thunder", OpeningUtils.getWeighted(Material.YELLOW_STAINED_GLASS_PANE, 100.0));
        HashMap<String, WeightedItem<NightItem>> clearItems = new HashMap<String, WeightedItem<NightItem>>();
        clearItems.put("clear", OpeningUtils.getWeighted(Material.AIR, 100.0));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.REWARD, k -> new HashMap()).put("default", new RewardProvider(RARITIES));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(animCloud, new AnimationProvider(cloudItems));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(animThunder, new AnimationProvider(thunderItems));
        config.getSpinnerProviderMap().computeIfAbsent(SpinnerType.ANIMATION, k -> new HashMap()).put(animClear, new AnimationProvider(clearItems));
    }

    @NotNull
    private static Map<String, WeightedItem<NightItem>> getRainbowPanes() {
        HashMap<String, WeightedItem<NightItem>> rainbowItems = new HashMap<String, WeightedItem<NightItem>>();
        rainbowItems.put("s1", OpeningUtils.getWeighted(Material.WHITE_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s2", OpeningUtils.getWeighted(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s3", OpeningUtils.getWeighted(Material.GRAY_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s4", OpeningUtils.getWeighted(Material.BLACK_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s5", OpeningUtils.getWeighted(Material.BROWN_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s6", OpeningUtils.getWeighted(Material.RED_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s7", OpeningUtils.getWeighted(Material.ORANGE_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s8", OpeningUtils.getWeighted(Material.YELLOW_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s9", OpeningUtils.getWeighted(Material.LIME_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s10", OpeningUtils.getWeighted(Material.GREEN_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s11", OpeningUtils.getWeighted(Material.CYAN_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s12", OpeningUtils.getWeighted(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s13", OpeningUtils.getWeighted(Material.BLUE_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s14", OpeningUtils.getWeighted(Material.PURPLE_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s15", OpeningUtils.getWeighted(Material.MAGENTA_STAINED_GLASS_PANE, 1.0));
        rainbowItems.put("s16", OpeningUtils.getWeighted(Material.PINK_STAINED_GLASS_PANE, 1.0));
        return rainbowItems;
    }

    private static WeightedItem<NightItem> getWeighted(@NotNull Material material, double weight) {
        return new WeightedItem((Object)NightItem.fromType((Material)material), weight);
    }
}

