/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.inventory;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.opening.OpeningProvider;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.opening.inventory.InvOpeningType;
import su.nightexpress.excellentcrates.opening.inventory.InventoryOpening;
import su.nightexpress.excellentcrates.opening.inventory.impl.NormalInvOpening;
import su.nightexpress.excellentcrates.opening.inventory.impl.SelectionInvOpening;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerData;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerProvider;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerType;
import su.nightexpress.excellentcrates.opening.inventory.spinner.provider.AnimationProvider;
import su.nightexpress.excellentcrates.opening.inventory.spinner.provider.RewardProvider;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.NightMessage;

public class InvOpeningProvider
extends AbstractFileData<CratesPlugin>
implements OpeningProvider {
    private MenuType invType;
    private String invTitle;
    private InvOpeningType mode;
    private int[] winSlots;
    private long maxTicksForSkip;
    private long completionPauseTicks;
    private int selectionAmount;
    private int[] selectionSlots;
    private NightItem selectionOriginIcon;
    private NightItem selectionClickedIcon;
    private final Map<String, MenuItem> defaultItems = new HashMap<String, MenuItem>();
    private final Map<SpinnerType, Map<String, SpinnerData>> spinnerDataMap = new HashMap<SpinnerType, Map<String, SpinnerData>>();
    private final Map<SpinnerType, Map<String, SpinnerProvider>> spinnerProviderMap = new HashMap<SpinnerType, Map<String, SpinnerProvider>>();

    public InvOpeningProvider(@NotNull CratesPlugin plugin, @NotNull File file) {
        super((NightCorePlugin)plugin, file);
    }

    protected boolean onLoad(@NotNull FileConfig config) {
        this.invType = BukkitThing.getMenuType((String)((String)ConfigValue.create((String)"Settings.Menu_Type", (String)BukkitThing.toString((Keyed)MenuType.GENERIC_9X3), (String[])new String[0]).read(config)));
        this.invTitle = (String)ConfigValue.create((String)"Settings.Title", (String)"Opening %crate_name%", (String[])new String[0]).read(config);
        this.mode = (InvOpeningType)((Object)ConfigValue.create((String)"Settings.Mode", InvOpeningType.class, (Enum)InvOpeningType.NORMAL, (String[])new String[0]).read(config));
        this.winSlots = (int[])ConfigValue.create((String)"Settings.WinSlots", (int[])new int[0], (String[])new String[0]).read(config);
        this.maxTicksForSkip = (Long)ConfigValue.create((String)"Settings.Max_Ticks_To_Skip", (long)40L, (String[])new String[]{"Sets max. amount of the opening ticks while players can skip the opening animation.", "Set to -1 to disable (no skip)."}).read(config);
        this.completionPauseTicks = ((Integer)ConfigValue.create((String)"Settings.Completion_Pause_Ticks", (int)20, (String[])new String[]{"Sets how soon (in ticks) animation GUI will be closed when completed.", "[1 second = 20 ticks]", "[Default is 20 ticks]"}).read(config)).intValue();
        if (this.mode == InvOpeningType.SELECTION) {
            this.selectionAmount = (Integer)ConfigValue.create((String)"Settings.Selection.Amount", (int)1, (String[])new String[0]).read(config);
            this.selectionSlots = (int[])ConfigValue.create((String)"Settings.Selection.Slots", (int[])new int[0], (String[])new String[0]).read(config);
            this.selectionOriginIcon = (NightItem)ConfigValue.create((String)"Settings.Selection.Item_Original", (NightItem)new NightItem(Material.ENDER_CHEST), (String[])new String[0]).read(config);
            this.selectionClickedIcon = (NightItem)ConfigValue.create((String)"Settings.Selection.Item_Selected", (NightItem)new NightItem(Material.CHEST), (String[])new String[0]).read(config);
        }
        config.getSection("Content.Default").forEach(sId -> {
            NightItem item = config.getCosmeticItem("Content.Default." + sId + ".Item");
            int[] slots = config.getIntArray("Content.Default." + sId + ".Slots");
            this.defaultItems.put(sId.toLowerCase(), item.toMenuItem().setSlots(slots).build());
        });
        for (SpinnerType type : SpinnerType.values()) {
            String runPath = "Settings.RunOnLaunch." + type.name();
            String settingsPath = "Spinners." + type.name();
            config.getSection(runPath).forEach(sId -> {
                SpinnerData data = SpinnerData.read(config, runPath + "." + sId);
                if (data == null) {
                    return;
                }
                this.spinnerDataMap.computeIfAbsent(type, k -> new HashMap()).put(sId.toLowerCase(), data);
            });
            config.getSection(settingsPath).forEach(sId -> {
                Writeable provider = switch (type) {
                    default -> throw new MatchException(null, null);
                    case SpinnerType.REWARD -> RewardProvider.read(config, settingsPath + "." + sId);
                    case SpinnerType.ANIMATION -> AnimationProvider.read(config, settingsPath + "." + sId);
                };
                this.spinnerProviderMap.computeIfAbsent(type, k -> new HashMap()).put(sId.toLowerCase(), provider);
            });
        }
        return true;
    }

    @Override
    @NotNull
    public InventoryOpening createOpening(@NotNull Player player, @NotNull CrateSource source, @Nullable CrateKey key) {
        InventoryView view = this.invType.typed().create((HumanEntity)player, NightMessage.asLegacy((String)((String)source.getCrate().replacePlaceholders().apply(this.invTitle))));
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case InvOpeningType.SELECTION -> new SelectionInvOpening((CratesPlugin)this.plugin, this, view, player, source, key);
            case InvOpeningType.NORMAL -> new NormalInvOpening((CratesPlugin)this.plugin, this, view, player, source, key);
        };
    }

    protected void onSave(@NotNull FileConfig config) {
        config.set("Settings.Menu_Type", (Object)BukkitThing.toString((Keyed)this.invType));
        config.set("Settings.Title", (Object)this.invTitle);
        config.set("Settings.Mode", (Object)this.mode.name());
        config.setIntArray("Settings.WinSlots", this.winSlots);
        config.set("Settings.Max_Ticks_To_Skip", (Object)this.maxTicksForSkip);
        config.set("Settings.Completion_Pause_Ticks", (Object)this.completionPauseTicks);
        if (this.mode == InvOpeningType.SELECTION) {
            config.set("Settings.Selection.Amount", (Object)this.selectionAmount);
            config.setIntArray("Settings.Selection.Slots", this.selectionSlots);
            config.set("Settings.Selection.Item_Original", (Object)this.selectionOriginIcon);
            config.set("Settings.Selection.Item_Selected", (Object)this.selectionClickedIcon);
        }
        config.remove("Content");
        this.defaultItems.forEach((id, menuItem) -> {
            config.set("Content.Default." + id + ".Item", (Object)menuItem.getItem());
            config.setIntArray("Content.Default." + id + ".Slots", menuItem.getSlots());
        });
        this.spinnerDataMap.forEach((type, map) -> {
            String path = "Settings.RunOnLaunch." + type.name();
            config.remove(path);
            map.forEach((id, data) -> config.set(path + "." + id, data));
        });
        this.spinnerProviderMap.forEach((type, map) -> {
            String settingsPath = "Spinners." + type.name();
            config.remove(settingsPath);
            map.forEach((id, settings) -> config.set(settingsPath + "." + id, settings));
        });
    }

    @NotNull
    public Set<SpinnerData> getSpinnersToRun(@NotNull SpinnerType type) {
        return new HashSet<SpinnerData>(this.spinnerDataMap.getOrDefault((Object)type, Collections.emptyMap()).values());
    }

    @Nullable
    public SpinnerProvider getSpinnerProvider(@NotNull SpinnerType type, @NotNull String id) {
        return (SpinnerProvider)this.spinnerProviderMap.getOrDefault((Object)type, Collections.emptyMap()).get(id.toLowerCase());
    }

    public void setInvType(@NotNull MenuType invType) {
        this.invType = invType;
    }

    public void setInvTitle(@NotNull String invTitle) {
        this.invTitle = invTitle;
    }

    @NotNull
    public InvOpeningType getMode() {
        return this.mode;
    }

    public void setMode(@NotNull InvOpeningType mode) {
        this.mode = mode;
    }

    public int[] getWinSlots() {
        return this.winSlots;
    }

    public void setWinSlots(int[] winSlots) {
        this.winSlots = winSlots;
    }

    public long getMaxTicksForSkip() {
        return this.maxTicksForSkip;
    }

    public void setMaxTicksForSkip(long maxTicksForSkip) {
        this.maxTicksForSkip = maxTicksForSkip;
    }

    public long getCompletionPauseTicks() {
        return this.completionPauseTicks;
    }

    public void setCompletionPauseTicks(long completionPauseTicks) {
        this.completionPauseTicks = completionPauseTicks;
    }

    public int getSelectionAmount() {
        return this.selectionAmount;
    }

    public void setSelectionAmount(int selectionAmount) {
        this.selectionAmount = selectionAmount;
    }

    public int[] getSelectionSlots() {
        return this.selectionSlots;
    }

    public void setSelectionSlots(int[] selectionSlots) {
        this.selectionSlots = selectionSlots;
    }

    public NightItem getSelectionOriginIcon() {
        return this.selectionOriginIcon;
    }

    public void setSelectionOriginIcon(NightItem selectionOriginIcon) {
        this.selectionOriginIcon = selectionOriginIcon;
    }

    public NightItem getSelectionClickedIcon() {
        return this.selectionClickedIcon;
    }

    public void setSelectionClickedIcon(NightItem selectionClickedIcon) {
        this.selectionClickedIcon = selectionClickedIcon;
    }

    @NotNull
    public Map<String, MenuItem> getDefaultItems() {
        return this.defaultItems;
    }

    @NotNull
    public Map<SpinnerType, Map<String, SpinnerData>> getSpinnerDataMap() {
        return this.spinnerDataMap;
    }

    @NotNull
    public Map<SpinnerType, Map<String, SpinnerProvider>> getSpinnerProviderMap() {
        return this.spinnerProviderMap;
    }
}

