/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.inventory.spinner.impl;

import java.util.HashMap;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.opening.inventory.InventoryOpening;
import su.nightexpress.excellentcrates.opening.inventory.spinner.AbstractSpinner;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerData;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.random.Rnd;

public class RewardSpinner
extends AbstractSpinner {
    private final Set<Rarity> rarities;

    public RewardSpinner(@NotNull SpinnerData data, @NotNull InventoryOpening opening, @NotNull Set<Rarity> rarities) {
        super(data, opening);
        this.rarities = rarities;
    }

    @Override
    @NotNull
    public ItemStack createItem() {
        Crate crate = this.opening.getCrate();
        Player player = this.opening.getPlayer();
        HashMap rarityMap = new HashMap();
        this.rarities.forEach(rarity -> {
            if (crate.hasRewards(player, (Rarity)rarity)) {
                rarityMap.put(rarity, rarity.getWeight());
            }
        });
        if (rarityMap.isEmpty()) {
            return new ItemStack(Material.AIR);
        }
        Rarity rarity2 = (Rarity)Rnd.getByWeight(rarityMap);
        Reward reward = this.opening.getCrate().rollReward(this.opening.getPlayer(), rarity2);
        ItemStack item = reward.getPreviewItem();
        PDCUtil.set((ItemStack)item, (NamespacedKey)Keys.rewardId, (String)reward.getId());
        return item;
    }

    @Override
    protected void onStop() {
        if (this.isCompleted()) {
            this.checkRewards();
        }
    }

    private void checkRewards() {
        for (int slot : this.opening.getConfig().getWinSlots()) {
            Reward reward;
            String rewardId;
            ItemStack item;
            if (!Lists.contains((int[])this.slots, (int)slot) || (item = this.opening.getView().getItem(slot)) == null || item.getType().isAir() || (rewardId = (String)PDCUtil.getString((ItemStack)item, (NamespacedKey)Keys.rewardId).orElse(null)) == null || (reward = this.opening.getCrate().getReward(rewardId)) == null) continue;
            reward.give(this.opening.getPlayer());
            CrateUtils.callRewardObtainEvent(this.opening.getPlayer(), reward);
            PDCUtil.remove((ItemStack)item, (NamespacedKey)Keys.rewardId);
        }
    }
}

