/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.world.impl;

import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.opening.OpeningUtils;
import su.nightexpress.excellentcrates.opening.world.WorldOpening;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.bukkit.NightSound;

public class SimpleRollOpening
extends WorldOpening {
    private final int stepsAmount;
    private final long stepsTick;
    private final long maxTicks;
    private int step;
    private Item rewardDisplay;
    private Reward reward;
    private Location displayLocation;

    public SimpleRollOpening(@NotNull CratesPlugin plugin, @NotNull Player player, @NotNull CrateSource source, @Nullable CrateKey key, int stepsAmount, long stepsTick, long completePause) {
        super(plugin, player, source, key);
        this.stepsAmount = stepsAmount;
        this.stepsTick = stepsTick;
        this.maxTicks = (long)this.stepsAmount * this.stepsTick + completePause;
    }

    private void onFirstTick() {
        Location center;
        Block block = this.source.getBlock();
        if (block == null) {
            Location playerLoc = this.player.getEyeLocation().clone();
            Vector direction = playerLoc.getDirection();
            for (int i = 0; i < 3; ++i) {
                playerLoc.add(direction);
            }
            center = LocationUtil.setCenter3D((Location)playerLoc);
        } else {
            double offset = Math.max(0.0, this.crate.getHologramYOffset());
            double height = block.getBoundingBox().getHeight() + offset;
            center = LocationUtil.setCenter2D((Location)block.getLocation()).add(0.0, height, 0.0);
        }
        this.displayLocation = center;
        this.hideHologram();
    }

    @Override
    public void instaRoll() {
        this.step = this.stepsAmount - 1;
        this.roll();
        if (this.tickCount > 0L) {
            this.displayRoll();
        }
        this.tickCount = this.maxTicks;
        this.stop();
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected void onTick() {
        if (this.tickCount == 0L) {
            this.onFirstTick();
        }
        if (this.tickCount % this.stepsTick == 0L && this.step < this.stepsAmount) {
            this.roll();
            this.displayRoll();
        }
    }

    @Override
    protected void onComplete() {
        this.reward.give(this.player);
        CrateUtils.callRewardObtainEvent(this.player, this.reward);
    }

    @Override
    protected void onStop() {
        if (this.rewardDisplay != null) {
            this.rewardDisplay.remove();
            this.rewardDisplay = null;
        }
        this.showHologram();
        super.onStop();
    }

    @Override
    public boolean isCompleted() {
        return this.tickCount >= this.maxTicks;
    }

    private void roll() {
        this.reward = this.crate.rollReward(this.player);
        ++this.step;
        if (this.step == this.stepsAmount) {
            this.setRefundable(false);
        }
    }

    private void displayRoll() {
        if (this.rewardDisplay == null) {
            this.rewardDisplay = (Item)this.player.getWorld().spawn(this.displayLocation, Item.class, item -> item.setVelocity(new Vector()));
            this.rewardDisplay.setPersistent(false);
            this.rewardDisplay.setCustomNameVisible(true);
            this.rewardDisplay.setGravity(false);
            this.rewardDisplay.setPickupDelay(Integer.MAX_VALUE);
            this.rewardDisplay.setUnlimitedLifetime(true);
            this.rewardDisplay.setInvulnerable(true);
        }
        if (this.rewardDisplay != null) {
            ItemStack itemStack = this.reward.getPreviewItem();
            this.rewardDisplay.setItemStack(itemStack);
            this.rewardDisplay.setCustomName(this.reward.getNameTranslated());
        }
        NightSound.of((Sound)Sound.UI_BUTTON_CLICK, (float)0.5f).play(this.displayLocation);
        NightSound.of((Sound)Sound.BLOCK_NOTE_BLOCK_BELL, (float)0.5f).play(this.displayLocation);
        if (this.step == this.stepsAmount) {
            NightSound.of((Sound)Sound.ENTITY_GENERIC_EXPLODE, (float)0.7f).play(this.displayLocation);
            OpeningUtils.createFirework(this.displayLocation);
        }
    }
}

