/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.util.inspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.util.inspect.Inspection;
import su.nightexpress.excellentcrates.util.inspect.InspectionInfo;
import su.nightexpress.excellentcrates.util.inspect.InspectionResult;
import su.nightexpress.nightcore.util.placeholder.PlaceholderList;

public class Inspector<T> {
    private static final String LOG_PREFIX = "-> ";
    private final Map<String, Inspection<T>> inspectionsMap = new HashMap<String, Inspection<T>>();

    @NotNull
    public static <T> Inspector<T> create(@NotNull Consumer<Inspector<T>> consumer) {
        Inspector<T> inspector = new Inspector<T>();
        consumer.accept(inspector);
        return inspector;
    }

    @NotNull
    public Inspector<T> addInspection(@NotNull Inspection<T> inspection) {
        this.inspectionsMap.put(inspection.name().toLowerCase(), inspection);
        return this;
    }

    public int countProblems(@NotNull T object) {
        return (int)this.getInspections().stream().map(inspection -> inspection.inspect(object)).filter(info -> info.getResult() != InspectionResult.GOOD).count();
    }

    public boolean hasProblems(@NotNull T object) {
        return this.countProblems(object) > 0;
    }

    public void addPlaceholders(@NotNull PlaceholderList<T> list) {
        this.inspectionsMap.forEach((type, inspection) -> list.add(Placeholders.INSPECTION_TYPE.apply((Inspection<?>)inspection), source -> inspection.inspect(source).getColored()));
        list.add("%inspection_problems%", source -> {
            int problems = this.countProblems(source);
            String string = (problems > 0 ? Lang.INSPECTION_PROBLEMS : Lang.INSPECTION_NO_PROBLEMS).getString().replace("%amount%", String.valueOf(problems));
            return problems > 0 ? Lang.badEntry((String)string) : Lang.goodEntry((String)string);
        });
    }

    public void printConsole(@NotNull CratesPlugin plugin, @NotNull T object, @NotNull String header) {
        ArrayList infos = new ArrayList();
        this.getInspections().forEach(inspection -> {
            InspectionInfo info = inspection.inspect(object);
            if (info.getResult() == InspectionResult.GOOD) {
                return;
            }
            infos.add(info);
        });
        if (infos.isEmpty()) {
            return;
        }
        plugin.warn(header);
        infos.forEach(info -> {
            String message = LOG_PREFIX + info.getMessage();
            switch (info.getResult()) {
                case BAD: {
                    plugin.error(message);
                    break;
                }
                case WARN: {
                    plugin.warn(message);
                }
            }
        });
    }

    @NotNull
    public Map<String, Inspection<T>> getInspectionsMap() {
        return this.inspectionsMap;
    }

    @NotNull
    public Set<Inspection<T>> getInspections() {
        return new HashSet<Inspection<T>>(this.inspectionsMap.values());
    }
}

