/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.util.pos;

import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;

public class BlockPos {
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public static BlockPos empty() {
        return new BlockPos(0, 0, 0);
    }

    @NotNull
    public static BlockPos from(@NotNull Block block) {
        return new BlockPos(block.getX(), block.getY(), block.getZ());
    }

    @NotNull
    public static BlockPos from(@NotNull Location location) {
        return new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public static BlockPos read(@NotNull FileConfig config, @NotNull String path) {
        String str = config.getString(path, "");
        return BlockPos.deserialize(str);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path, (Object)this.serialize());
    }

    @NotNull
    public static BlockPos deserialize(@NotNull String str) {
        String[] split = str.split(",");
        if (split.length < 3) {
            return BlockPos.empty();
        }
        int x = (int)NumberUtil.getAnyDouble((String)split[0], (double)0.0);
        int y = (int)NumberUtil.getAnyDouble((String)split[1], (double)0.0);
        int z = (int)NumberUtil.getAnyDouble((String)split[2], (double)0.0);
        return new BlockPos(x, y, z);
    }

    @NotNull
    public String serialize() {
        return this.x + "," + this.y + "," + this.z;
    }

    @NotNull
    public Location toLocation(@NotNull World world) {
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    @NotNull
    public Block toBlock(@NotNull World world) {
        return world.getBlockAt(this.x, this.y, this.z);
    }

    @NotNull
    public Chunk toChunk(@NotNull World world) {
        int chunkX = this.x >> 4;
        int chunkZ = this.z >> 4;
        return world.getChunkAt(chunkX, chunkZ);
    }

    public boolean isChunkLoaded(@NotNull World world) {
        int chunkX = this.x >> 4;
        int chunkZ = this.z >> 4;
        return world.isChunkLoaded(chunkX, chunkZ);
    }

    @NotNull
    public BlockPos copy() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean isEmpty() {
        return (double)this.x == 0.0 && (double)this.y == 0.0 && (double)this.z == 0.0;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockPos)) {
            return false;
        }
        BlockPos other = (BlockPos)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public int hashCode() {
        return (this.y + this.z * 31) * 31 + this.x;
    }

    public String toString() {
        return "BlockPos{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

