/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.util.pos;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.util.pos.BlockPos;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.NumberUtil;

public class WorldPos {
    public static final WorldPos EMPTY = new WorldPos("", BlockPos.empty());
    private final int x;
    private final int y;
    private final int z;
    private final String worldName;
    private Reference<World> worldReference;

    public WorldPos(@NotNull String worldName, @NotNull BlockPos blockPos) {
        this(worldName, blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public WorldPos(@NotNull String worldName, int x, int y, int z) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public static WorldPos empty() {
        return EMPTY.copy();
    }

    @NotNull
    public static WorldPos from(@NotNull Block block) {
        return new WorldPos(block.getWorld().getName(), BlockPos.from(block));
    }

    @NotNull
    public static WorldPos from(@NotNull Location location) {
        return new WorldPos(LocationUtil.getWorldName((Location)location), BlockPos.from(location));
    }

    @NotNull
    public static WorldPos read(@NotNull FileConfig config, @NotNull String path) {
        String str = config.getString(path, "");
        return WorldPos.deserialize(str);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path, (Object)this.serialize());
    }

    @NotNull
    public static WorldPos deserialize(@NotNull String str) {
        String[] split = str.split(",");
        if (split.length < 4) {
            return WorldPos.empty();
        }
        int x = (int)NumberUtil.getAnyDouble((String)split[0], (double)0.0);
        int y = (int)NumberUtil.getAnyDouble((String)split[1], (double)0.0);
        int z = (int)NumberUtil.getAnyDouble((String)split[2], (double)0.0);
        String worldName = split[3];
        return new WorldPos(worldName, x, y, z);
    }

    @NotNull
    public String serialize() {
        return this.x + "," + this.y + "," + this.z + "," + this.worldName;
    }

    @Nullable
    public World getWorld() {
        World world;
        if ((this.worldReference == null || this.worldReference.get() == null) && (world = Bukkit.getWorld((String)this.worldName)) != null) {
            this.worldReference = new WeakReference<World>(world);
        }
        return this.worldReference == null ? null : this.worldReference.get();
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public WorldPos copy() {
        return new WorldPos(this.worldName, this.x, this.y, this.z);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    @Nullable
    public Location toLocation() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    @Nullable
    public Block toBlock() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return world.getBlockAt(this.x, this.y, this.z);
    }

    @Nullable
    public Chunk toChunk() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        int chunkX = this.x >> 4;
        int chunkZ = this.z >> 4;
        return world.getChunkAt(chunkX, chunkZ);
    }

    public boolean isChunkLoaded() {
        World world = this.getWorld();
        if (world == null) {
            return false;
        }
        int chunkX = this.x >> 4;
        int chunkZ = this.z >> 4;
        return world.isChunkLoaded(chunkX, chunkZ);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorldPos)) {
            return false;
        }
        WorldPos other = (WorldPos)object;
        return this.x == other.x && this.y == other.y && this.z == other.z && Objects.equals(this.worldName, other.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.worldName);
    }

    public String toString() {
        return "WorldPos{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", worldName='" + this.worldName + "'}";
    }
}

