/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.api;

import codes.cookies.mod.api.ApiManager;
import codes.cookies.mod.utils.json.JsonUtils;
import com.mojang.authlib.exceptions.AuthenticationException;
import dev.morazzer.cookies.entities.request.AuthRequest;
import dev.morazzer.cookies.entities.response.AuthResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_320;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApiAuthProcess {
    private static CompletableFuture<String> current;

    public static void setup() {
        current = new CompletableFuture();
    }

    public static void start() {
        class_320 session = class_310.method_1551().method_1548();
        UUID uuid = UUID.randomUUID();
        try {
            class_310.method_1551().method_1495().joinServer(session.method_44717(), session.method_1674(), uuid.toString());
        }
        catch (AuthenticationException e) {
            throw new RuntimeException(e);
        }
        try (CloseableHttpClient client = HttpClientBuilder.create().setUserAgent(ApiManager.USER_AGENT).build();){
            HttpPost httpPost = new HttpPost(ApiManager.getPath("login"));
            httpPost.setEntity(ApiAuthProcess.createLoginEntity(uuid, session.method_1676()));
            httpPost.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            try {
                CloseableHttpResponse execute = client.execute((HttpUriRequest)httpPost);
                ApiAuthProcess.processResponse((HttpResponse)execute);
            }
            catch (IOException e) {
                current.completeExceptionally(new AuthException(AuthException.Reason.FAILED_TO_CONNECT));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void processResponse(HttpResponse execute) {
        if (execute.getStatusLine().getStatusCode() != 200) {
            current.completeExceptionally(new AuthException(AuthException.Reason.OTHER));
            return;
        }
        HttpEntity entity = execute.getEntity();
        if (entity == null) {
            current.completeExceptionally(new AuthException(AuthException.Reason.FAILED_TO_CONNECT));
            return;
        }
        try {
            byte[] bytes = entity.getContent().readAllBytes();
            AuthResponse authResponse = (AuthResponse)JsonUtils.CLEAN_GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), AuthResponse.class);
            if (authResponse == null) {
                current.completeExceptionally(new AuthException(AuthException.Reason.FAILED_TO_CONNECT));
                return;
            }
            current.complete(authResponse.token());
        }
        catch (IOException e) {
            current.completeExceptionally(new AuthException(AuthException.Reason.INTERNAL_ERROR));
        }
    }

    private static HttpEntity createLoginEntity(UUID uuid, String username) {
        AuthRequest authRequest = new AuthRequest(uuid.toString(), username);
        return new StringEntity(JsonUtils.CLEAN_GSON.toJson((Object)authRequest), ContentType.APPLICATION_JSON);
    }

    @Generated
    public static CompletableFuture<String> getCurrent() {
        return current;
    }

    static class AuthException
    extends Exception {
        private final Reason reason;

        @Generated
        public AuthException(Reason reason) {
            this.reason = reason;
        }

        @Generated
        public Reason getReason() {
            return this.reason;
        }

        static enum Reason {
            FAILED_TO_CONNECT,
            UNAUTHORIZED,
            INTERNAL_ERROR,
            OTHER;

        }
    }
}

