/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.api;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.api.ApiAuthProcess;
import codes.cookies.mod.api.ws.WebsocketConnection;
import codes.cookies.mod.config.categories.DevCategory;
import codes.cookies.mod.events.WebsocketEvent;
import codes.cookies.mod.generated.BuildInfo;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import dev.morazzer.cookies.entities.websocket.Packet;
import dev.morazzer.cookies.entities.websocket.packets.HandshakePacket;
import dev.morazzer.cookies.entities.websocket.packets.WrongProtocolVersionPacket;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.packet.impl.clientbound.ClientboundHelloPacket;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiManager.class);
    public static String USER_AGENT;
    static CloseableHttpClient CLIENT;
    private static boolean isAuthenticated;
    private static UUID lastAuthenticatedUser;
    private static String token;
    private static ScheduledFuture<?> authTask;

    public static String getPath(String path) {
        String apiUrl = ApiManager.getApiUrl();
        return apiUrl + path;
    }

    public static void initialize() {
        HypixelModAPI.getInstance().createHandler(ClientboundHelloPacket.class, ApiManager::onJoinHypixel);
        ClientPlayConnectionEvents.DISCONNECT.register(ApiManager::onDisconnectServer);
        Packet.onReceive(HandshakePacket.class, ApiManager::handleHandshake);
        Packet.onReceive(WrongProtocolVersionPacket.class, ApiManager::handleWrongProtocolVersion);
        USER_AGENT = "CookiesMod/%s (%s)".formatted(BuildInfo.version.toString(), class_155.method_16673().method_48019());
        CookiesMod.getExecutorService().scheduleAtFixedRate(WebsocketConnection::sendPing, 1L, 1L, TimeUnit.MINUTES);
    }

    private static void onJoinHypixel(ClientboundHelloPacket clientboundHelloPacket) {
        ApiManager.connectApi();
    }

    private static void handleWrongProtocolVersion(WrongProtocolVersionPacket wrongProtocolVersionPacket) {
        CookiesUtils.sendFailedMessage((class_2561)class_2561.method_43471((String)"cookies.backend.wrong_version"));
    }

    private static void handleHandshake(HandshakePacket packet) {
        if (DevUtils.isDevEnvironment()) {
            CookiesUtils.sendSuccessMessage("Handshake completed");
        }
        ((Runnable)WebsocketEvent.CONNECT.invoker()).run();
    }

    public static void reconnect() {
        ApiManager.disconnectApi();
        lastAuthenticatedUser = null;
        ApiManager.connectApi();
    }

    private static void onDisconnectServer(class_634 clientPlayNetworkHandler, class_310 minecraftClient) {
        ApiManager.disconnectApi();
    }

    private static void disconnectApi() {
        if (WebsocketConnection.getInstance() != null) {
            WebsocketConnection.getInstance().cancelSchedule();
            WebsocketConnection.getInstance().disconnect();
        }
        if (!isAuthenticated) {
            return;
        }
        if (authTask != null) {
            authTask.cancel(true);
        }
        isAuthenticated = false;
        if (CLIENT != null) {
            try {
                CLIENT.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void connectApi() {
        if (!((Boolean)DevCategory.connectToBackend.get()).booleanValue()) {
            return;
        }
        if (isAuthenticated) {
            return;
        }
        if (lastAuthenticatedUser != null && lastAuthenticatedUser.equals(class_310.method_1551().method_1548().method_44717())) {
            CookiesMod.getExecutorService().submit(ApiManager::finishAuth);
            return;
        }
        ApiAuthProcess.setup();
        CookiesMod.getExecutorService().submit(ApiAuthProcess::start);
        ApiAuthProcess.getCurrent().whenComplete(ApiManager::completeAuthentication);
        if (authTask != null) {
            authTask.cancel(false);
        }
        authTask = null;
    }

    private static void completeAuthentication(String apiToken, Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof ApiAuthProcess.AuthException) {
                ApiAuthProcess.AuthException authException = (ApiAuthProcess.AuthException)throwable;
                ApiManager.handleApiAuthError(authException);
            } else {
                log.error("Failed to authenticate", throwable);
                ApiManager.handleUnknown();
            }
            return;
        }
        lastAuthenticatedUser = class_310.method_1551().method_1548().method_44717();
        token = apiToken;
        ApiManager.finishAuth();
    }

    private static void finishAuth() {
        if (CLIENT != null) {
            try {
                CLIENT.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (DevUtils.isDevEnvironment()) {
            CookiesUtils.sendSuccessMessage("Successfully connected to backend!");
        }
        isAuthenticated = true;
        CLIENT = HttpClientBuilder.create().setUserAgent(USER_AGENT).disableAuthCaching().setDefaultHeaders(List.of(new BasicHeader("Authorization", "Bearer " + token))).build();
        WebsocketConnection.create().connect();
    }

    private static void handleUnknown() {
        ApiManager.scheduleAuthentication(2);
        CookiesUtils.sendFailedMessage("Unable to connect to backend due to an unknown issue, trying again in two minutes.");
    }

    public static void scheduleAuthentication(int minutes) {
        if (authTask != null) {
            authTask.cancel(false);
        }
        authTask = CookiesMod.getExecutorService().schedule(ApiManager::connectApi, (long)minutes, TimeUnit.MINUTES);
    }

    private static void handleApiAuthError(ApiAuthProcess.AuthException throwable) {
        ApiAuthProcess.AuthException.Reason reason = throwable.getReason();
        if (reason == ApiAuthProcess.AuthException.Reason.FAILED_TO_CONNECT) {
            ApiManager.scheduleAuthentication(5);
            CookiesUtils.sendFailedMessage("Failed to connect to backend, trying again in five minutes.");
            return;
        }
        if (reason == ApiAuthProcess.AuthException.Reason.INTERNAL_ERROR) {
            ApiManager.scheduleAuthentication(1);
            CookiesUtils.sendFailedMessage("Failed to connect to backed due to an internal error, trying again in one minute.");
            return;
        }
        log.error("Failed to authenticate", (Throwable)throwable);
        ApiManager.handleUnknown();
    }

    public static String getApiUrl() {
        String value = DevCategory.backendUrl;
        Object apiUrl = value.lastIndexOf("/") == value.length() - 1 ? value : value + "/";
        if (DevCategory.useVersionSuffix) {
            return (String)apiUrl + "v1/";
        }
        return apiUrl;
    }

    @Generated
    public static String getToken() {
        return token;
    }
}

