/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.api.ws;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.api.ApiManager;
import codes.cookies.mod.events.WebsocketEvent;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import dev.morazzer.cookies.entities.websocket.Packet;
import dev.morazzer.cookies.entities.websocket.Side;
import dev.morazzer.cookies.entities.websocket.packets.HandshakePacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class WebsocketConnection
implements WebSocket.Listener {
    private static WebsocketConnection instance;
    public boolean isConnected;
    private WebSocket webSocket;
    int tries = 1;
    private ScheduledFuture<?> schedule;
    private ByteArrayOutputStream current = new ByteArrayOutputStream();
    private CompletableFuture<?> future = new CompletableFuture();

    public static WebsocketConnection create() {
        if (instance != null) {
            instance.disconnect();
        }
        instance = new WebsocketConnection();
        return instance;
    }

    public void connect() {
        this.disconnect();
        try (HttpClient build = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).version(HttpClient.Version.HTTP_2).build();){
            String scheme = URI.create(ApiManager.getApiUrl()).getScheme();
            String websocketScheme = scheme.endsWith("s") ? "wss" : "ws";
            String s = ApiManager.getPath("websocket").replaceFirst(scheme + "://", websocketScheme + "://");
            this.webSocket = build.newWebSocketBuilder().header("Authorization", "Bearer " + ApiManager.getToken()).buildAsync(URI.create(s), this).join();
            WebsocketConnection.sendMessage(new HandshakePacket());
            this.cancelSchedule();
        }
        catch (Exception e) {
            CookiesUtils.sendFailedMessage("Backend connection lost, try reconnecting! (in %ss)".formatted(this.tries * 5));
            this.reconnect(this.tries++ * 5);
        }
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.isConnected = true;
        this.tries = 1;
        this.current = new ByteArrayOutputStream();
        if (DevUtils.isDevEnvironment()) {
            CookiesUtils.sendMessage("Successfully connected to backend server!");
        }
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        if (this.webSocket != webSocket) {
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }
        ((Runnable)WebsocketEvent.DISCONNECT.invoker()).run();
        this.isConnected = false;
        System.out.println(reason + " " + statusCode);
        if (statusCode != 1000) {
            CookiesUtils.sendFailedMessage("Backend connection lost, try reconnecting! (in %ss)".formatted(this.tries * 5));
            this.reconnect(this.tries++ * 5);
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    public static void sendPing() {
        if (WebsocketConnection.getInstance() == null) {
            return;
        }
        WebsocketConnection.getInstance().webSocket.sendPing(ByteBuffer.wrap("ping".getBytes()));
    }

    private void reconnect(int time) {
        this.cancelSchedule();
        this.schedule = CookiesMod.getExecutorService().schedule(this::connect, (long)time, TimeUnit.SECONDS);
    }

    public void cancelSchedule() {
        if (this.schedule != null) {
            this.schedule.cancel(true);
            this.schedule = null;
        }
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.current.writeBytes(bytes);
        webSocket.request(1L);
        if (last) {
            this.handleMessage(this.current.toByteArray());
            this.current.reset();
            this.future.complete(null);
            CompletableFuture<?> future = this.future;
            this.future = new CompletableFuture();
            return future;
        }
        return this.future;
    }

    private void handleMessage(byte[] byteArray) throws IOException {
        Side.PACKETS.deserializeAndSend(byteArray);
    }

    public static void sendMessageAsync(Packet<?> packet) {
        if (WebsocketConnection.getInstance() == null) {
            return;
        }
        WebsocketConnection.getInstance().sendMessageAsyncInternal(packet);
    }

    public static void sendMessage(Packet<?> packet) {
        if (WebsocketConnection.getInstance() == null) {
            return;
        }
        WebsocketConnection.getInstance().sendMessageInternal(packet);
    }

    private void sendMessageAsyncInternal(Packet<?> packet) {
        CookiesMod.getExecutorService().execute(() -> this.sendMessageInternal(packet));
    }

    private void sendMessageInternal(Packet<?> packet) {
        byte[] serialize = Side.PACKETS.serializeUnknown(packet);
        this.webSocket.sendBinary(ByteBuffer.wrap(serialize), true);
    }

    public void disconnect() {
        if (this.webSocket != null && !this.webSocket.isOutputClosed()) {
            this.webSocket.sendClose(1000, "Disconnected");
            this.webSocket = null;
        }
    }

    @Generated
    public static WebsocketConnection getInstance() {
        return instance;
    }
}

