/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.commands.system.ClientCommand;
import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.ForgeRecipe;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.screen.inventory.ForgeRecipeScreen;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class ViewForgeRecipeCommand
extends ClientCommand {
    @Override
    @NotNull
    public LiteralArgumentBuilder<FabricClientCommandSource> getCommand() {
        return (LiteralArgumentBuilder)this.literal("viewforgerecipe").then(this.argument("recipe", StringArgumentType.greedyString()).suggests(this::suggest).executes(this.run(this::open)));
    }

    private CompletableFuture<Suggestions> suggest(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder suggestionsBuilder) {
        List<RepositoryItem> list = Recipe.ALL_FORGE_RECIPES.stream().map(ForgeRecipe::getOutput).map(Ingredient::getRepositoryItem).toList();
        ArrayList suggest = new ArrayList();
        list.stream().map(RepositoryItem::getInternalId).forEach(suggest::add);
        list.stream().map(RepositoryItem::getName).map(class_2561::getString).forEach(suggest::add);
        return class_2172.method_9265(suggest, (SuggestionsBuilder)suggestionsBuilder);
    }

    private void open(CommandContext<FabricClientCommandSource> context) {
        if (!MiscCategory.showForgeRecipes) {
            this.sendFailedMessage("Forge recipes aren't enabled, to use this command enable them in the config! (/cookie:config)");
            return;
        }
        String recipe = (String)context.getArgument("recipe", String.class);
        List<RepositoryItem> list = Recipe.ALL_FORGE_RECIPES.stream().map(ForgeRecipe::getOutput).map(Ingredient::getRepositoryItem).toList();
        RepositoryItem repositoryItem = list.stream().filter(this.doesMatch(recipe)).findFirst().orElse(null);
        if (repositoryItem == null) {
            this.sendFailedMessage("No recipe found for '" + recipe + "'");
            return;
        }
        CookiesMod.openScreen(new ForgeRecipeScreen(repositoryItem.getRecipes().stream().filter(ForgeRecipe.class::isInstance).map(ForgeRecipe.class::cast).findFirst().orElse(null), null));
    }

    private Predicate<? super RepositoryItem> doesMatch(String recipe) {
        return repositoryItem -> repositoryItem.getInternalId().equalsIgnoreCase(recipe) || repositoryItem.getName().getString().equalsIgnoreCase(recipe);
    }
}

