/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands.arguments;

import codes.cookies.mod.utils.cookies.CookiesUtils;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.NotBlank;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RealIdentifierArgument
implements ArgumentType<class_2960> {
    private static final SimpleCommandExceptionType COMMAND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.id.invalid"));
    private static final DynamicCommandExceptionType IDENTIFIER_NOT_FOUND = new DynamicCommandExceptionType(id -> CookiesUtils.createPrefix(-38559).method_27693("Identifier %s not found".formatted(id)));
    private final Collection<class_2960> identifierCollection;
    private final String namespace;
    private final String pathPrefix;

    public RealIdentifierArgument(@NotNull Collection<class_2960> identifierCollection) {
        this(identifierCollection, "minecraft");
    }

    public RealIdentifierArgument(@NotNull Collection<class_2960> identifierCollection, @NotBlank @NotNull String namespace) {
        this(identifierCollection, namespace, "");
    }

    public RealIdentifierArgument(@NotNull Collection<class_2960> identifierCollection, @NotBlank @NotNull String namespace, @NotBlank @NotNull String pathPrefix) {
        this.identifierCollection = identifierCollection;
        this.namespace = namespace;
        this.pathPrefix = pathPrefix;
    }

    public class_2960 parse(@NotNull StringReader reader) throws CommandSyntaxException {
        class_2960 identifier = this.fromCommandInput(reader);
        if (!this.identifierCollection.contains(identifier)) {
            throw IDENTIFIER_NOT_FOUND.create((Object)identifier);
        }
        return identifier;
    }

    public class_2960 fromCommandInput(@NotNull StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && class_2960.method_12831((char)reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(i, reader.getCursor());
        try {
            String[] split = this.split(string);
            return class_2960.method_60655((String)split[0], (String)split[1]);
        }
        catch (class_151 invalidIdentifierException) {
            reader.setCursor(i);
            throw COMMAND_EXCEPTION.createWithContext((ImmutableStringReader)reader);
        }
    }

    @NotNull
    @Contract(pure=true)
    protected String[] split(@NotNull String id) {
        String[] strings = new String[]{this.namespace, this.pathPrefix + id};
        int i = id.indexOf(58);
        if (i >= 0) {
            strings[1] = id.substring(i + 1);
            if (i >= 1) {
                strings[0] = id.substring(0, i);
            }
        }
        return strings;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            this.identifierCollection.forEach(identifier -> builder.suggest(identifier.toString()));
        } else {
            this.identifierCollection.stream().filter(((Predicate<class_2960>)i -> i.toString().startsWith(builder.getRemaining())).or(i -> i.method_12832().startsWith(builder.getRemaining())).or(i -> i.method_12832().startsWith(this.pathPrefix + builder.getRemaining()))).map(class_2960::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }

    @Contract(pure=true)
    @NotNull
    public Collection<String> getExamples() {
        return Arrays.asList("%s:%sdebug_logging".formatted(this.namespace, this.pathPrefix), "%s:%s".formatted(this.namespace, this.pathPrefix.isBlank() ? "test" : this.pathPrefix));
    }
}

