/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands.dev;

import codes.cookies.mod.commands.system.ClientCommand;
import codes.cookies.mod.utils.dev.DevUtils;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import org.jetbrains.annotations.NotNull;

public class ExtraLoggingCommand
extends ClientCommand {
    @Override
    @NotNull
    public LiteralArgumentBuilder<FabricClientCommandSource> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("extra-logging").then(this.literal("add").then(this.argument("key", StringArgumentType.greedyString()).executes(this.run(this::add))))).then(this.literal("remove").then(this.argument("key", StringArgumentType.greedyString()).suggests(this::suggestRemove).executes(this.run(this::remove))));
    }

    private void add(CommandContext<FabricClientCommandSource> context) {
        String key = (String)context.getArgument("key", String.class);
        boolean contains = DevUtils.getEnabledExtraLogging().contains(key);
        if (contains) {
            this.sendFailedMessage("Key %s is already enabled".formatted(key));
            return;
        }
        DevUtils.getEnabledExtraLogging().add(key);
        this.sendSuccessMessage("Added key %s to extra logging".formatted(key));
    }

    private CompletableFuture<Suggestions> suggestRemove(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder suggestionsBuilder) {
        class_2172.method_9265(DevUtils.getEnabledExtraLogging(), (SuggestionsBuilder)suggestionsBuilder);
        return suggestionsBuilder.buildFuture();
    }

    private void remove(CommandContext<FabricClientCommandSource> context) {
        String key = (String)context.getArgument("key", String.class);
        boolean contains = DevUtils.getEnabledExtraLogging().contains(key);
        if (!contains) {
            this.sendFailedMessage("Key %s is not active".formatted(key));
            return;
        }
        DevUtils.getEnabledExtraLogging().remove(key);
        this.sendSuccessMessage("Removed key %s from extra logging".formatted(key));
    }
}

