/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands.dev.debug;

import codes.cookies.mod.commands.system.ClientCommand;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.sub.RancherSpeeds;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import org.jetbrains.annotations.NotNull;

public class ProfileDataDebugCommand
extends ClientCommand {
    @Override
    @NotNull
    public LiteralArgumentBuilder<FabricClientCommandSource> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("profileData").then(this.literal("load").executes(this.run(this::load)))).then(this.literal("save").executes(this.run(this::save)))).then(this.literal("storage").then(this.literal("clear").executes(this.run(this::clearStorage))))).then(this.literal("sacks").then(this.literal("clear").executes(this.run(this::clearSacks))))).then(this.literal("chests").then(this.literal("clear").executes(this.run(this::clearChests))))).then(this.literal("rancher_speeds").then(this.literal("reset").executes(this.run(this::resetRancherSpeeds))));
    }

    private void resetRancherSpeeds() {
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        currentProfile.ifPresent(profileData -> profileData.setRancherSpeeds(new RancherSpeeds((ProfileData)profileData)));
        this.sendSuccessMessage("Reset rancher speeds for the current profile");
        this.save();
    }

    private void clearChests() {
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        currentProfile.flatMap(ProfileData::getGlobalProfileData).ifPresent(global -> global.getIslandStorage().clear());
        this.sendSuccessMessage("Deleted all chest data for the current profile");
        this.save();
    }

    private void clearStorage() {
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        currentProfile.ifPresent(profileData -> profileData.getStorageData().clear());
        this.sendSuccessMessage("Deleted all storage data for the current profile");
        this.save();
    }

    private void clearSacks() {
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        currentProfile.ifPresent(profileData -> profileData.getSackTracker().clear());
        this.sendSuccessMessage("Deleted all sack data for the current profile");
        this.save();
    }

    private void save() {
        ProfileStorage.saveCurrentProfile();
        this.sendSuccessMessage("Saved the current profile");
    }

    private void load() {
        this.sendMessage("Loading the current profile");
        ProfileStorage.loadCurrentProfile(true);
    }
}

