/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands.dev.debug;

import codes.cookies.mod.commands.arguments.RealIdentifierArgument;
import codes.cookies.mod.commands.system.ClientCommand;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculationResult;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculator;
import codes.cookies.mod.repository.recipes.calculations.RecipePrinter;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class RecipeCalculationDebugCommand
extends ClientCommand {
    @Override
    @NotNull
    public LiteralArgumentBuilder<FabricClientCommandSource> getCommand() {
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        RepositoryItem.getItemMap().keySet().forEach(item -> identifiers.add(class_2960.method_60655((String)"skyblock", (String)item.replace(":", "/").replace("-", "/").replace(";", "/").toLowerCase(Locale.ROOT))));
        return (LiteralArgumentBuilder)this.literal("recipeCalculation").then(this.argument("item", new RealIdentifierArgument(identifiers)).executes(this.run(this::calculate)));
    }

    private void calculate(CommandContext<FabricClientCommandSource> context) {
        class_2960 item = (class_2960)context.getArgument("item", class_2960.class);
        RepositoryItem repositoryItem = RepositoryItem.of(item.method_12832());
        Optional first = repositoryItem.getRecipes().stream().findFirst();
        if (first.isEmpty()) {
            this.sendFailedMessage("Item doesn't have a recipe");
            return;
        }
        Recipe recipe = (Recipe)first.get();
        RecipeCalculationResult calculate = RecipeCalculator.calculate(recipe).getResult().orElseThrow();
        String s = RecipePrinter.printRecipe(calculate);
        this.sendInformation("Recipes for " + String.valueOf(repositoryItem.getName()));
        this.sendRawMessage(s);
    }
}

