/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands.system;

import codes.cookies.mod.commands.system.ClientCommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.SingleRedirectModifier;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ClientCommand
implements ClientCommandHelper {
    private static final class_2960 identifier = class_2960.method_60655((String)"cookie", (String)"commands");

    public static void loadCommands(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, ClientCommand ... commands) {
        for (ClientCommand command : commands) {
            command.register(dispatcher);
        }
    }

    public void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder<FabricClientCommandSource> command = this.getCommand();
        if (!this.isAvailableOnServers()) {
            Predicate requirement = command.getRequirement();
            command.requires(fabricClientCommandSource -> {
                class_638 world = class_310.method_1551().field_1687;
                return (this.isAvailableOnServers() || world != null && world.method_8608()) && requirement.test(fabricClientCommandSource);
            });
        }
        LiteralCommandNode register = dispatcher.register(command);
        for (String alias : this.getAliases()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal(alias).executes(command.getCommand())).requires(command.getRequirement())).redirect((CommandNode)register, this.getRedirectModifier(alias)));
            if (alias.startsWith("cookie")) {
                alias = alias.substring(6);
            }
            String namespace = String.format("%s:%s", identifier.method_12836(), alias);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal(namespace).executes(command.getCommand())).requires(command.getRequirement())).redirect((CommandNode)register, this.getRedirectModifier(namespace)));
        }
        String name = register.getName();
        if (name.startsWith("cookie")) {
            name = name.substring(6);
        }
        String namespace = String.format("%s:%s", identifier.method_12836(), name);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal(namespace).executes(command.getCommand())).requires(command.getRequirement())).redirect((CommandNode)register, this.getRedirectModifier(namespace)));
    }

    @NotNull
    public abstract LiteralArgumentBuilder<FabricClientCommandSource> getCommand();

    @Contract(pure=true)
    public boolean isAvailableOnServers() {
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @NotNull
    public SingleRedirectModifier<FabricClientCommandSource> getRedirectModifier(@NotNull String commandName) {
        return CommandContext::getSource;
    }
}

