/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.commands.system;

import codes.cookies.mod.commands.system.ClientCommand;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientCommandHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger(ClientCommand.class);

    default public LiteralArgumentBuilder<FabricClientCommandSource> literal(String command) {
        return LiteralArgumentBuilder.literal((String)command);
    }

    default public <S> RequiredArgumentBuilder<FabricClientCommandSource, S> argument(String name, ArgumentType<S> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    default public Command<FabricClientCommandSource> run(Consumer<CommandContext<FabricClientCommandSource>> consumer) {
        return context -> {
            consumer.accept(context);
            return 1;
        };
    }

    default public Command<FabricClientCommandSource> run(Runnable runnable) {
        return context -> {
            runnable.run();
            return 1;
        };
    }

    default public <T> T create(T value, UnaryOperator<T> config) {
        return (T)config.apply(value);
    }

    default public Command<FabricClientCommandSource> runAndWrap(ThrowingConsumer<CommandContext<FabricClientCommandSource>> consumer) {
        return context -> {
            try {
                consumer.accept(context);
            }
            catch (Throwable e) {
                LOGGER.error("Command execution exception", e);
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43471((String)"cookies.unexpected_error"));
                return 1;
            }
            return 1;
        };
    }

    default public void sendRawMessage(String message) {
        CookiesUtils.sendRawMessage(message);
    }

    default public void sendInformation(String message) {
        CookiesUtils.sendInformation(message);
    }

    default public void sendMessage(String message) {
        CookiesUtils.sendWhiteMessage(message);
    }

    default public void sendFailedMessage(String message) {
        CookiesUtils.sendFailedMessage(message);
    }

    default public void sendSuccessMessage(String message) {
        CookiesUtils.sendSuccessMessage(message);
    }

    default public boolean ensureDevEnvironment(FabricClientCommandSource source) {
        return DevUtils.isDevEnvironment();
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

