/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.config;

import codes.cookies.mod.config.ConfigMigrator;
import codes.cookies.mod.config.CookiesConfig;
import codes.cookies.mod.config.CookiesOptions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamresourceful.resourcefulconfig.api.loader.Configurator;
import com.teamresourceful.resourcefulconfig.api.patching.ConfigPatchEvent;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.loader.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    public static final Configurator CONFIGURATOR = new Configurator("cookies-mod");
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private static final Path configFolder = Path.of("config/cookiesmod", new String[0]);
    private static final Path configFile = configFolder.resolve("config.json");
    private static boolean hasBeenLoaded = false;

    public static boolean isLoaded() {
        return hasBeenLoaded;
    }

    public static void load() {
        CookiesOptions.register();
        CONFIGURATOR.register(CookiesConfig.class, ConfigManager::registerMigrations);
        ConfigManager.migrateToNewConfigSystemIfRequired();
        hasBeenLoaded = true;
    }

    public static void saveConfig(String reason) {
        log.info("Saving config: {}", (Object)reason);
        ConfigManager.save();
    }

    public static void save() {
        CONFIGURATOR.saveConfig(CookiesConfig.class);
    }

    private static void migrateToNewConfigSystemIfRequired() {
        JsonObject configObject;
        if (!Files.exists(configFile, new LinkOption[0])) {
            return;
        }
        log.info("Detected old config file, migrating to new system!");
        try (InputStream stream = Files.newInputStream(configFile, new OpenOption[0]);){
            byte[] bytes = stream.readAllBytes();
            configObject = JsonParser.parseString((String)new String(bytes, StandardCharsets.UTF_8)).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject jsonObject = ConfigMigrator.migrateToNewConfig(configObject);
        ResourcefulConfig config = CONFIGURATOR.getConfig(CookiesConfig.class);
        Loader.loadConfig((ResourcefulConfig)config, (JsonObject)jsonObject);
        config.save();
        try {
            Files.delete(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerMigrations(ConfigPatchEvent configPatchEvent) {
    }
}

