/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data;

import codes.cookies.mod.data.Migration;
import codes.cookies.mod.data.profile.migrations.GlobalProfileDataMigration_0001;
import codes.cookies.mod.data.profile.migrations.ProfileDataMigration_0001;
import codes.cookies.mod.data.profile.migrations.ProfileDataMigration_0002;
import codes.cookies.mod.data.profile.migrations.ProfileDataMigration_0003;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMigrations {
    private static final String KEY = "migration";
    private static final List<Migration<JsonObject>> MIGRATIONS = new LinkedList<Migration<JsonObject>>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cookies-mod/migrations");

    private DataMigrations() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean migrate(JsonObject jsonObject, Migration.Type type) {
        if (!jsonObject.has(KEY)) {
            jsonObject.addProperty(KEY, (Number)-1);
        }
        long lastApplied = jsonObject.get(KEY).getAsLong();
        for (Migration migration : MIGRATIONS.stream().sorted(Comparator.comparingLong(Migration::getNumber)).toList()) {
            if (migration.getType() != type || (long)migration.getNumber() <= lastApplied) continue;
            LOGGER.info("Applying migration {} for type {}", (Object)migration.getNumber(), (Object)type);
            try {
                migration.apply(jsonObject);
            }
            catch (Exception e) {
                if (migration.mayFail()) {
                    LOGGER.error("Failed to apply migration {} for type {}! Continuing since it's marked as optional!", new Object[]{migration.getNumber(), type, e});
                    continue;
                }
                LOGGER.error("Failed to apply mandatory migration {} for type {}", new Object[]{migration.getNumber(), type, e});
                return false;
            }
        }
        return true;
    }

    public static void writeLatest(JsonObject jsonObject, Migration.Type type) {
        jsonObject.addProperty(KEY, (Number)type.getLatest());
    }

    static {
        MIGRATIONS.addAll(Arrays.asList(new ProfileDataMigration_0001(), new GlobalProfileDataMigration_0001(), new ProfileDataMigration_0002(), new ProfileDataMigration_0003()));
        MIGRATIONS.stream().collect(Collectors.groupingBy(Migration::getType)).forEach((key, value) -> key.setLatest(value.stream().max(Comparator.comparingInt(Migration::getNumber)).map(Migration::getNumber).orElse(-1)));
    }
}

