/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.cookiesmoddata;

import codes.cookies.mod.data.cookiesmoddata.CookieDataInstances;
import codes.cookies.mod.data.cookiesmoddata.CookiesModData;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class CookieDataManager {
    public static final Path MOD_DATA_FOLDER = Path.of(FabricLoader.getInstance().getConfigDir().toString(), "cookiesmod/data");

    public static void load() {
        if (!Files.exists(MOD_DATA_FOLDER, new LinkOption[0])) {
            ExceptionHandler.tryCatch(() -> Files.createDirectories(MOD_DATA_FOLDER, new FileAttribute[0]));
        }
        for (Field declaredField : CookieDataInstances.class.getDeclaredFields()) {
            ExceptionHandler.tryCatch(() -> CookieDataManager.loadField(declaredField));
        }
    }

    public static void save(CookiesModData modData) {
        Path dataLocation = MOD_DATA_FOLDER.resolve(modData.getFileLocation());
        JsonElement jsonElement = modData.write();
        byte[] content = jsonElement.toString().getBytes(StandardCharsets.UTF_8);
        ExceptionHandler.tryCatch(() -> CookieDataManager.saveFile(dataLocation, content));
    }

    private static void loadField(Field declaredField) {
        byte[] bytes;
        Object instance;
        declaredField.setAccessible(true);
        try {
            instance = declaredField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (!(instance instanceof CookiesModData)) {
            return;
        }
        CookiesModData data = (CookiesModData)instance;
        Path dataLocation = MOD_DATA_FOLDER.resolve(data.getFileLocation());
        if (!Files.exists(dataLocation, new LinkOption[0])) {
            return;
        }
        try {
            bytes = CookieDataManager.readFile(dataLocation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileContent = new String(bytes, StandardCharsets.UTF_8);
        JsonElement fileElement = JsonParser.parseString((String)fileContent);
        if (fileElement.isJsonObject()) {
            data.read((JsonElement)fileElement.getAsJsonObject());
        }
    }

    private static byte[] readFile(Path filePath) throws IOException {
        return Files.readAllBytes(filePath);
    }

    private static void saveFile(Path filePath, byte[] content) {
        Files.write(filePath, content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

