/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.mining;

import codes.cookies.mod.data.mining.PowderType;
import codes.cookies.mod.events.mining.PowderUpdateEvent;
import codes.cookies.mod.utils.json.CodecJsonSerializable;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class PowderData
implements CodecJsonSerializable<Map<PowderType, Integer>> {
    public static final Codec<Map<PowderType, Integer>> CODEC = Codec.unboundedMap(PowderType.CODEC, (Codec)Codec.INT);
    private final Map<PowderType, Integer> trackedPowder = new HashMap<PowderType, Integer>();

    public void update(PowderType powderType, int amount) {
        if (this.trackedPowder.containsKey((Object)powderType)) {
            int old = this.remove(powderType);
            int delta = amount - old;
            this.trackedPowder.put(powderType, amount);
            this.broadcastUpdate(powderType, amount, delta);
            return;
        }
        this.trackedPowder.put(powderType, amount);
        this.broadcastUpdate(powderType, amount, 0);
    }

    private void broadcastUpdate(PowderType powderType, int amount, int delta) {
        if (delta == 0) {
            return;
        }
        ((PowderUpdateEvent)PowderUpdateEvent.EVENT.invoker()).update(powderType, amount, delta);
    }

    private int remove(PowderType powderType) {
        Integer remove = this.trackedPowder.remove((Object)powderType);
        if (remove == null) {
            return 0;
        }
        return remove;
    }

    @Override
    public Codec<Map<PowderType, Integer>> getCodec() {
        return CODEC;
    }

    @Override
    public void load(Map<PowderType, Integer> value) {
        this.trackedPowder.putAll(value);
    }

    @Override
    public Map<PowderType, Integer> getValue() {
        return this.trackedPowder;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    public void reset() {
        this.trackedPowder.clear();
    }
}

