/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.player;

import codes.cookies.mod.data.player.PlayerData;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class PlayerStorage {
    static final Path playerDataFolder = Path.of("config/cookiesmod/players", new String[0]);
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static PlayerData playerData;

    @NotNull
    public static Optional<PlayerData> getPlayerData() {
        if (!PlayerStorage.getCurrentPlayer().flatMap(player -> Optional.ofNullable(playerData).map(data -> data.getPlayerUuid().equals(player))).orElse(false).booleanValue()) {
            PlayerStorage.savePlayerData();
            PlayerStorage.loadPlayerData();
        }
        return Optional.ofNullable(playerData);
    }

    public static Optional<UUID> getCurrentPlayer() {
        return Optional.of(class_310.method_1551()).map(minecraftClient -> minecraftClient.field_1724).map(class_1297::method_5667);
    }

    public static void savePlayerData() {
        if (playerData == null) {
            return;
        }
        if (PlayerStorage.getCurrentPlayer().isEmpty()) {
            return;
        }
        UUID player = PlayerStorage.getCurrentPlayer().get();
        Path playerDataFile = playerDataFolder.resolve(String.valueOf(player) + ".json");
        try {
            Files.writeString(playerDataFile, (CharSequence)GSON.toJson((Object)playerData), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static void loadPlayerData() {
        String content;
        if (PlayerStorage.getCurrentPlayer().isEmpty()) {
            return;
        }
        UUID player = PlayerStorage.getCurrentPlayer().get();
        Path playerDataFile = playerDataFolder.resolve(String.valueOf(player) + ".json");
        if (!Files.exists(playerDataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(playerDataFolder, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (!Files.exists(playerDataFile, new LinkOption[0])) {
            playerData = new PlayerData(player);
            PlayerStorage.savePlayerData();
        }
        try {
            content = Files.readString(playerDataFile);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        playerData = (PlayerData)GSON.fromJson(content, PlayerData.class);
    }
}

