/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile;

import codes.cookies.mod.data.farming.squeakymousemat.SqueakyMousematData;
import codes.cookies.mod.data.mining.PowderData;
import codes.cookies.mod.data.mining.crystal.CrystalStatusData;
import codes.cookies.mod.data.player.PlayerStorage;
import codes.cookies.mod.data.profile.GameMode;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.profile.GlobalProfileData;
import codes.cookies.mod.data.profile.profile.GlobalProfileStorage;
import codes.cookies.mod.data.profile.sub.AccessoryItemData;
import codes.cookies.mod.data.profile.sub.CraftHelperData;
import codes.cookies.mod.data.profile.sub.EquipmentData;
import codes.cookies.mod.data.profile.sub.ForgeTracker;
import codes.cookies.mod.data.profile.sub.HotmData;
import codes.cookies.mod.data.profile.sub.MiscItemData;
import codes.cookies.mod.data.profile.sub.PlotData;
import codes.cookies.mod.data.profile.sub.ProfileStats;
import codes.cookies.mod.data.profile.sub.RancherSpeeds;
import codes.cookies.mod.data.profile.sub.SackTracker;
import codes.cookies.mod.data.profile.sub.StorageData;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.json.Exclude;
import codes.cookies.mod.utils.json.Safe;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public class ProfileData {
    private UUID playerUuid;
    private UUID profileUuid;
    private GameMode gameMode = GameMode.UNKNOWN;
    private CraftHelperData craftHelperData = new CraftHelperData();
    @Safe
    private SackTracker sackTracker = new SackTracker();
    private RancherSpeeds rancherSpeeds = new RancherSpeeds(this);
    private StorageData storageData = new StorageData();
    @Exclude
    private GlobalProfileData globalProfileData;
    private ForgeTracker forgeTracker = new ForgeTracker();
    private HotmData hotmData = new HotmData();
    private MiscItemData miscTracker = new MiscItemData();
    private AccessoryItemData accessoryTracker = new AccessoryItemData();
    private ProfileStats profileStats = new ProfileStats();
    private EquipmentData equipmentData = new EquipmentData();
    private PlotData plotData = new PlotData();
    private SqueakyMousematData squeakyMousematData = SqueakyMousematData.getDefault();
    private PowderData powderData = new PowderData();
    private CrystalStatusData crystalStatus = new CrystalStatusData();

    public ProfileData(UUID playerUuid, UUID profileUuid) {
        this.playerUuid = playerUuid;
        this.profileUuid = profileUuid;
    }

    public GameMode getGameMode() {
        if (this.gameMode == GameMode.UNKNOWN && SkyblockUtils.isCurrentlyInSkyblock()) {
            ProfileStorage.saveCurrentProfile();
        }
        return this.gameMode;
    }

    public boolean isActive() {
        return PlayerStorage.getCurrentPlayer().map(uuid -> uuid.equals(this.playerUuid)).orElse(false) != false && SkyblockUtils.getLastProfileId().map(uuid -> uuid.equals(this.profileUuid)).orElse(false) != false;
    }

    public void load() {
        this.globalProfileData = GlobalProfileStorage.load(this.profileUuid);
    }

    public void save() {
        GlobalProfileStorage.save(this.globalProfileData);
    }

    public Optional<GlobalProfileData> getGlobalProfileData() {
        return Optional.ofNullable(this.globalProfileData);
    }

    public String toString() {
        return "ProfileData{playerUuid=" + String.valueOf(this.playerUuid) + ", profileUuid=" + String.valueOf(this.profileUuid) + ", gameMode=" + String.valueOf((Object)this.gameMode) + "}";
    }

    @Generated
    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    @Generated
    public UUID getProfileUuid() {
        return this.profileUuid;
    }

    @Generated
    public CraftHelperData getCraftHelperData() {
        return this.craftHelperData;
    }

    @Generated
    public SackTracker getSackTracker() {
        return this.sackTracker;
    }

    @Generated
    public RancherSpeeds getRancherSpeeds() {
        return this.rancherSpeeds;
    }

    @Generated
    public StorageData getStorageData() {
        return this.storageData;
    }

    @Generated
    public ForgeTracker getForgeTracker() {
        return this.forgeTracker;
    }

    @Generated
    public HotmData getHotmData() {
        return this.hotmData;
    }

    @Generated
    public MiscItemData getMiscTracker() {
        return this.miscTracker;
    }

    @Generated
    public AccessoryItemData getAccessoryTracker() {
        return this.accessoryTracker;
    }

    @Generated
    public ProfileStats getProfileStats() {
        return this.profileStats;
    }

    @Generated
    public EquipmentData getEquipmentData() {
        return this.equipmentData;
    }

    @Generated
    public PlotData getPlotData() {
        return this.plotData;
    }

    @Generated
    public SqueakyMousematData getSqueakyMousematData() {
        return this.squeakyMousematData;
    }

    @Generated
    public PowderData getPowderData() {
        return this.powderData;
    }

    @Generated
    public CrystalStatusData getCrystalStatus() {
        return this.crystalStatus;
    }

    @Generated
    public void setCraftHelperData(CraftHelperData craftHelperData) {
        this.craftHelperData = craftHelperData;
    }

    @Generated
    public void setRancherSpeeds(RancherSpeeds rancherSpeeds) {
        this.rancherSpeeds = rancherSpeeds;
    }

    @Generated
    public void setStorageData(StorageData storageData) {
        this.storageData = storageData;
    }

    @Generated
    public void setGlobalProfileData(GlobalProfileData globalProfileData) {
        this.globalProfileData = globalProfileData;
    }

    @Generated
    public void setForgeTracker(ForgeTracker forgeTracker) {
        this.forgeTracker = forgeTracker;
    }

    @Generated
    public void setHotmData(HotmData hotmData) {
        this.hotmData = hotmData;
    }

    @Generated
    public void setMiscTracker(MiscItemData miscTracker) {
        this.miscTracker = miscTracker;
    }

    @Generated
    public void setAccessoryTracker(AccessoryItemData accessoryTracker) {
        this.accessoryTracker = accessoryTracker;
    }

    @Generated
    public void setProfileStats(ProfileStats profileStats) {
        this.profileStats = profileStats;
    }

    @Generated
    public void setEquipmentData(EquipmentData equipmentData) {
        this.equipmentData = equipmentData;
    }

    @Generated
    public void setPlotData(PlotData plotData) {
        this.plotData = plotData;
    }

    @Generated
    public void setSqueakyMousematData(SqueakyMousematData squeakyMousematData) {
        this.squeakyMousematData = squeakyMousematData;
    }

    @Generated
    public void setPowderData(PowderData powderData) {
        this.powderData = powderData;
    }

    @Generated
    public void setCrystalStatus(CrystalStatusData crystalStatus) {
        this.crystalStatus = crystalStatus;
    }

    @Generated
    public ProfileData(UUID playerUuid, UUID profileUuid, GameMode gameMode, CraftHelperData craftHelperData, SackTracker sackTracker, RancherSpeeds rancherSpeeds, StorageData storageData, GlobalProfileData globalProfileData, ForgeTracker forgeTracker, HotmData hotmData, MiscItemData miscTracker, AccessoryItemData accessoryTracker, ProfileStats profileStats, EquipmentData equipmentData, PlotData plotData, SqueakyMousematData squeakyMousematData, PowderData powderData, CrystalStatusData crystalStatus) {
        this.playerUuid = playerUuid;
        this.profileUuid = profileUuid;
        this.gameMode = gameMode;
        this.craftHelperData = craftHelperData;
        this.sackTracker = sackTracker;
        this.rancherSpeeds = rancherSpeeds;
        this.storageData = storageData;
        this.globalProfileData = globalProfileData;
        this.forgeTracker = forgeTracker;
        this.hotmData = hotmData;
        this.miscTracker = miscTracker;
        this.accessoryTracker = accessoryTracker;
        this.profileStats = profileStats;
        this.equipmentData = equipmentData;
        this.plotData = plotData;
        this.squeakyMousematData = squeakyMousematData;
        this.powderData = powderData;
        this.crystalStatus = crystalStatus;
    }

    @Generated
    private void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    @Generated
    private void setProfileUuid(UUID profileUuid) {
        this.profileUuid = profileUuid;
    }

    @Generated
    private void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    @Generated
    private void setSackTracker(SackTracker sackTracker) {
        this.sackTracker = sackTracker;
    }
}

